/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.logging;

import com.equestricraft.logging.IgnoreErrorLog;
import com.equestricraft.logging.LogEntry;
import com.equestricraft.logging.LogLevel;
import com.equestricraft.logging.LogListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private final Logger logger;
    private static final Executor logListenerProcessor = Executors.newSingleThreadExecutor();
    private static final List<LogListenerRegistration> listenerRegistrations = new ArrayList<LogListenerRegistration>();

    private Log(Logger logger) {
        this.logger = logger;
    }

    public void trace(String message) {
        this.logger.trace(message);
        Log.fireLogEntry(message, LogLevel.TRACE);
    }

    public void trace(String message, Object p1) {
        this.logger.trace(message, p1);
        Log.fireLogEntry(this.translateParams(message, p1), LogLevel.TRACE);
    }

    public void trace(String message, Object p1, Object p2) {
        this.logger.trace(message, p1, p2);
        Log.fireLogEntry(this.translateParams(message, p1, p2), LogLevel.TRACE);
    }

    public void trace(String message, Object ... param) {
        this.logger.trace(message, param);
        Log.fireLogEntry(this.translateParams(message, param), LogLevel.TRACE);
    }

    public void trace(Supplier<String> message) {
        if (this.logger.isTraceEnabled()) {
            this.trace(message.get());
        }
    }

    public void debug(String message) {
        this.logger.debug(message);
        Log.fireLogEntry(message, LogLevel.DEBUG);
    }

    public void debug(String message, Object p1) {
        this.logger.debug(message, p1);
        Log.fireLogEntry(this.translateParams(message, p1), LogLevel.DEBUG);
    }

    public void debug(String message, Object p1, Object p2) {
        this.logger.debug(message, p1, p2);
        Log.fireLogEntry(this.translateParams(message, p1, p2), LogLevel.DEBUG);
    }

    public void debug(String message, Object ... param) {
        this.logger.debug(message, param);
        Log.fireLogEntry(this.translateParams(message, param), LogLevel.DEBUG);
    }

    public void debug(Supplier<String> message) {
        if (this.logger.isDebugEnabled()) {
            this.debug(message.get());
        }
    }

    public void info(String message) {
        this.logger.info(message);
        Log.fireLogEntry(message, LogLevel.INFO);
    }

    public void info(String message, Object p1) {
        this.logger.info(message, p1);
        Log.fireLogEntry(this.translateParams(message, p1), LogLevel.INFO);
    }

    public void info(String message, Object p1, Object p2) {
        this.logger.info(message, p1, p2);
        Log.fireLogEntry(this.translateParams(message, p1, p2), LogLevel.INFO);
    }

    public void info(String message, Object ... param) {
        this.logger.info(message, param);
        Log.fireLogEntry(this.translateParams(message, param), LogLevel.INFO);
    }

    public void warn(String message) {
        this.logger.warn(message);
        Log.fireLogEntry(message, LogLevel.WARN);
    }

    public void warn(String message, Object p1) {
        this.logger.warn(message, p1);
        Log.fireLogEntry(this.translateParams(message, p1), LogLevel.WARN);
    }

    public void warn(String message, Object p1, Object p2) {
        this.logger.warn(message, p1, p2);
        Log.fireLogEntry(this.translateParams(message, p1, p2), LogLevel.WARN);
    }

    public void warn(String message, Object ... param) {
        this.logger.warn(message, param);
        Log.fireLogEntry(this.translateParams(message, param), LogLevel.WARN);
    }

    public void error(String message) {
        this.logger.error(message);
        Log.fireLogEntry(message, LogLevel.ERROR);
    }

    public void error(String message, Object p1) {
        this.logger.error(message, p1);
        Log.fireLogEntry(this.translateParams(message, p1), LogLevel.ERROR);
    }

    public void error(String message, Object p1, Object p2) {
        this.logger.error(message, p1, p2);
        Log.fireLogEntry(this.translateParams(message, p1, p2), LogLevel.ERROR);
    }

    public void error(String message, Object ... param) {
        this.logger.error(message, param);
        Log.fireLogEntry(this.translateParams(message, param), LogLevel.ERROR);
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(message, throwable);
        Log.fireLogEntry(message, LogLevel.ERROR, throwable);
    }

    private String translateParams(String string, Object ... params) {
        for (Object param : params) {
            String str = param != null ? param.toString() : "null";
            string = string.replaceFirst("\\{\\}", str);
        }
        return string;
    }

    public static void registerListener(LogListener logListener, LogLevel ... levels) {
        LogListenerRegistration registration = new LogListenerRegistration(logListener, levels);
        listenerRegistrations.add(registration);
    }

    private static void fireLogEntry(String message, LogLevel level) {
        Log.fireLogEntry(message, level, null);
    }

    private static void fireLogEntry(String message, LogLevel level, Throwable throwable) {
        logListenerProcessor.execute(() -> Log.fireLogEntryImpl(message, level, throwable));
    }

    private static void fireLogEntryImpl(String message, LogLevel level, Throwable throwable) {
        if (throwable != null && throwable.getClass().isAnnotationPresent(IgnoreErrorLog.class)) {
            return;
        }
        List<LogListener> listeners = listenerRegistrations.stream().filter(r -> Log.isForLevel(r, level)).map(LogListenerRegistration::logListener).toList();
        if (!listeners.isEmpty()) {
            LogEntry entry = new LogEntry(new Date(), level, message, throwable);
            listeners.forEach(l -> l.onLog(entry));
        }
    }

    private static boolean isForLevel(LogListenerRegistration registration, LogLevel level) {
        for (LogLevel registrationLevel : registration.levels()) {
            if (registrationLevel != level) continue;
            return true;
        }
        return false;
    }

    public static Log getLogger(String name) {
        return new Log(LoggerFactory.getLogger((String)name));
    }

    public static Log getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    private record LogListenerRegistration(LogListener logListener, LogLevel[] levels) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogListenerRegistration that = (LogListenerRegistration)o;
            return Objects.equals(this.logListener, that.logListener) && Arrays.equals((Object[])this.levels, (Object[])that.levels);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.logListener);
            result = 31 * result + Arrays.hashCode((Object[])this.levels);
            return result;
        }

        @Override
        public String toString() {
            return "Registration";
        }
    }
}

