/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod;

import com.equestricraft.base.database.Database;
import com.equestricraft.base.eventbus.ECEventHandlerCache;
import com.equestricraft.base.healthcheck.HealthCheckController;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.base.thread.ThreadChecker;
import com.equestricraft.cdi.ServiceInit;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.version.BuildInformation;
import com.equestricraft.core.Context;
import com.equestricraft.core.dataload.DataLoadController;
import com.equestricraft.core.entityload.EntityLoadController;
import com.equestricraft.core.repeatingtask.RepeatingTaskManager;
import com.equestricraft.core.system.SubSystemController;
import com.equestricraft.core.system.SubSystemStartupException;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.BlockInit;
import com.equestricraft.mod.EntityInit;
import com.equestricraft.mod.ModChunkGenerators;
import com.equestricraft.mod.ModDimensions;
import com.equestricraft.mod.Server;
import com.equestricraft.mod.ServerStateFile;
import com.equestricraft.mod.ServerStatusHandler;
import com.equestricraft.mod.StatusChecker;
import com.equestricraft.mod.client.i18n.ClientI18n;
import com.equestricraft.mod.i18n.ServerI18n;
import com.equestricraft.mod.network.PacketHandler;
import com.equestricraft.mod.scheduler.ModTaskScheduler;
import java.sql.SQLException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="equestricraft")
public class EquestriCraftMod {
    private static final Log log = Log.getLogger(EquestriCraftMod.class.getName());

    public EquestriCraftMod() {
        ReflectionHelper.addExclusion("com.equestricraft.mod.client");
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onCommonSetup);
        EntityInit.ENTITIES.register(bus);
        BlockInit.register(bus);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        ModChunkGenerators.registerCodecs();
        ModDimensions.register();
        PacketHandler.initPacketHandler();
        this.setContext();
        BuildInformation.printBuildInformation("EquestriCraft");
        EquestriCraftMod.setI18n();
    }

    private void setContext() {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            Context.setContext(0);
        } else {
            Context.setContext(1);
        }
    }

    private static void setI18n() {
        if (Context.isServer()) {
            I18n.setI18n(Services.getService(ServerI18n.class));
        } else {
            I18n.setI18n(new ClientI18n());
        }
    }

    @SubscribeEvent
    public void onServerStartup(ServerAboutToStartEvent event) {
        ServerStateFile.setStarting();
        Server.setServer(event.getServer());
        TaskScheduler.setAsyncTaskScheduler(new ModTaskScheduler());
        try {
            ServiceInit.initServices();
            ECEventHandlerCache.getInstance().loadEventHandlerCache();
            Services.getService(DataLoadController.class).initialize();
            EntityLoadController.initEntityLoader();
            SubSystemController.startUpSubSystems();
            StatusChecker.getInstance().start();
            RepeatingTaskManager.getInstance().start();
            HealthCheckController.getInstance().init();
            ThreadChecker.setReportServerThreadWarnings(true);
            ServerStatusHandler.getInstance().startSystemStateMonitor();
        }
        catch (SubSystemStartupException ex) {
            ServerLifecycleHooks.getCurrentServer().m_7570_(false);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        ServerStatusHandler.getInstance().serverStarted();
        ServerStateFile.setStarted();
        log.info("Server started fully");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) throws SQLException {
        log.info("Shutting down EquestriCraft Server");
        ServerStatusHandler.getInstance().serverStopped();
        ServerStateFile.setStopped();
        SubSystemController.shutDownSubSystems();
        Services.getService(Database.class).close();
    }
}

