/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod;

import com.equestricraft.logging.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ServerStateFile {
    private static final Path serverStateFilePath = Paths.get("server-state.txt", new String[0]);
    private static final Log log = Log.getLogger(ServerStateFile.class.getName());

    public static void setStarting() {
        ServerStateFile.writeContentsToFile("STARTING");
    }

    public static void setStarted() {
        ServerStateFile.writeContentsToFile("STARTED");
    }

    public static void setStopped() {
        ServerStateFile.writeContentsToFile("STOPPED");
    }

    private static void writeContentsToFile(String contents) {
        try {
            Files.write(serverStateFilePath, contents.getBytes(), new OpenOption[0]);
        }
        catch (IOException ex) {
            log.error("Error writing server state to file", ex);
        }
    }

    private ServerStateFile() {
    }
}

