/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod;

import com.equestricraft.common.ApplicationConstants;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.mod.healthmetric.TPS;
import com.equestricraft.synchronizer.SystemStatePublisher;
import java.util.Timer;
import java.util.TimerTask;

public class ServerStatusHandler {
    private static final ServerStatusHandler instance = new ServerStatusHandler();
    private static final SystemStatePublisher systemStatePublisher = SystemStatePublisher.createInstance("Forge Server");
    private boolean started = false;

    public static ServerStatusHandler getInstance() {
        return instance;
    }

    private ServerStatusHandler() {
    }

    public void serverStarted() {
        this.started = true;
        this.sendSystemStateUpdate();
    }

    public void serverStopped() {
        systemStatePublisher.publishSystemDown();
    }

    public void startSystemStateMonitor() {
        Timer statusUpdateTimer = new Timer(ThreadUtils.threadName("status-update"));
        statusUpdateTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ServerStatusHandler.this.sendSystemStateUpdate();
            }
        }, 0L, (long)ApplicationConstants.SYSTEM_STATUS_UPDATE_SECONDS.intValue() * 1000L);
    }

    private synchronized void sendSystemStateUpdate() {
        if (!this.started) {
            systemStatePublisher.publishImpairedState("Starting");
        } else {
            boolean lowTps;
            double tps = TPS.getCurrentTps();
            boolean bl = lowTps = tps < 15.0;
            if (lowTps) {
                systemStatePublisher.publishImpairedState("TPS is " + tps);
            }
        }
        systemStatePublisher.publishHealthyState();
    }
}

