/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod;

import com.equestricraft.base.healthcheck.HealthCheckService;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.status.StatusUpdateService;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.DEDICATED_SERVER)
public class StatusChecker {
    private static final StatusChecker instance = new StatusChecker();
    @Service
    private static StatusUpdateService statusUpdateService;
    private static final HealthCheckService healthCheckService;

    public static StatusChecker getInstance() {
        return instance;
    }

    private StatusChecker() {
    }

    public synchronized void start() {
        Timer timer = new Timer(ThreadUtils.threadName("status-monitor"));
        long internal = 10000L;
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                StatusChecker.this.runChecks();
            }
        }, internal, internal);
    }

    private void runChecks() {
        statusUpdateService.sendStatusUpdate(this.getBadServices());
    }

    private List<String> getBadServices() {
        return healthCheckService.getBadServices();
    }

    static {
        healthCheckService = HealthCheckService.getInstance();
    }
}

