/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.afk;

import com.equestricraft.cdi.Service;
import com.equestricraft.mod.afk.AfkService;
import com.equestricraft.mod.movement.PlayerMoveEvent;
import com.equestricraft.mod.player.ECPlayerLeaveEvent;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class AfkListener {
    @Service
    private static AfkService afkService;

    @SubscribeEvent
    public static void clearAfkOnActivity(PlayerMoveEvent event) {
        afkService.clearAfk(event.getPlayer());
    }

    @SubscribeEvent
    public static void clearAfkOnChat(ServerChatEvent event) {
        afkService.clearAfk(event.getPlayer().m_142081_());
    }

    @SubscribeEvent
    public static void clearAfkOnCommand(CommandEvent commandEvent) {
        try {
            ServerPlayer player = ((CommandSourceStack)commandEvent.getParseResults().getContext().getSource()).m_81375_();
            afkService.clearAfk(player.m_142081_());
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void clearDataOnLogout(ECPlayerLeaveEvent event) {
        event.getPlayer().getAfk().clearAfk();
    }

    private AfkListener() {
    }
}

