/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.afk;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.afk.AfkService;
import com.equestricraft.mod.player.notification.ModPlayerNotificationService;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

public class AfkServiceImpl
implements AfkService {
    @Service
    private ModPlayerNotificationService modPlayerNotificationService;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public Response setAfk(ECPlayer player) {
        TaskScheduler.executeAsyncTask(() -> player.getAfk().setAfk(), Duration.ofSeconds(1L));
        return ResponseFactory.success(I18n.getLabel("afk.you-are-now-afk"));
    }

    @Override
    public void clearAfk(ECPlayer player) {
        Optional<Date> afkSince = player.getAfk().getAfkSince();
        player.getAfk().clearAfk();
        if (afkSince.isPresent()) {
            this.modPlayerNotificationService.notifyPlayerOfNewNotificationsSinceTime(player, afkSince.get());
            player.sendMessage(I18n.getLabel("afk.you-are-no-longer-afk"));
        }
    }

    @Override
    public void clearAfk(UUID playerUuid) {
        Optional<ECPlayer> player = this.onlinePlayerCache.getPlayer(playerUuid);
        player.ifPresent(this::clearAfk);
    }
}

