/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.animation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;

public class AnimationSpeedCache {
    private static final AnimationSpeedCache instance = new AnimationSpeedCache();
    private final Map<String, Float> speedsMap = new HashMap<String, Float>();
    private final StampedLock lock = new StampedLock();

    public static AnimationSpeedCache getInstance() {
        return instance;
    }

    private AnimationSpeedCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeed(String animation, float value) {
        long stamp = this.lock.readLock();
        try {
            this.speedsMap.put(animation, Float.valueOf(value));
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Float> getSpeed(String animation) {
        long stamp = this.lock.readLock();
        try {
            Optional<Float> optional = Optional.ofNullable(this.speedsMap.get(animation));
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public Map<String, Float> getAll() {
        return Collections.unmodifiableMap(this.speedsMap);
    }
}

