/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.animation;

import com.equestricraft.common.AnimationSpeedUpdateMessage;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.mod.animation.AnimationSpeedCache;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ClientBoundAnimationSpeedFactorUpdatePacket;
import com.equestricraft.redis.RedisChannelSubscription;
import java.util.Collections;
import java.util.Map;

public class AnimationSpeedSystem
implements SubSystem {
    private final AnimationSpeedCache animationSpeedCache = AnimationSpeedCache.getInstance();
    private final RedisChannelSubscription<AnimationSpeedUpdateMessage> featureFlagUpdateMessageRedisChannelSubscription = new RedisChannelSubscription("animation-speed-update");

    @Override
    public void onEnable() {
        this.featureFlagUpdateMessageRedisChannelSubscription.subscribe(update -> {
            this.animationSpeedCache.setSpeed(update.getAnimationName(), update.getSpeedFactor());
            Map<String, Float> map = Collections.singletonMap(update.getAnimationName(), Float.valueOf(update.getSpeedFactor()));
            ClientBoundAnimationSpeedFactorUpdatePacket packet = new ClientBoundAnimationSpeedFactorUpdatePacket(map);
            Network.sendToAll(packet);
        });
    }
}

