/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.approval;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.approval.PlayerPendingApproval;
import com.equestricraft.core.approval.PlayerPendingApprovalCache;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.mod.approval.PendingApprovalItem;
import com.equestricraft.mod.approval.PendingApprovalService;
import com.equestricraft.mod.packet.ClientBoundPendingApprovalsMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class PendingApprovalServiceImpl
implements PendingApprovalService {
    @Service
    private PlayerTransformer playerTransformer;
    private final PlayerPendingApprovalCache playerPendingApprovalCache = PlayerPendingApprovalCache.getInstance();

    @Override
    public void showPendingApprovals(OnlinePlayer player) {
        List<PlayerPendingApproval> approvals = this.playerPendingApprovalCache.getApprovalsForPlayer(player);
        List<PendingApprovalItem> items = approvals.stream().sorted(Comparator.comparing(PlayerPendingApproval::getCreatedDate)).map(a -> {
            Duration durationSince = DateUtils.durationSince(a.getCreatedDate());
            return new PendingApprovalItem(a.getUuid(), a.getMessage(), this.playerTransformer.toSimple(a.getSourcePlayer().getCorePlayer()), PendingApprovalServiceImpl.convertDurationToString(durationSince));
        }).toList();
        ClientBoundPendingApprovalsMenuOpenPacket packet = new ClientBoundPendingApprovalsMenuOpenPacket(items);
        player.sendPacket(packet);
    }

    public static String convertDurationToString(Duration duration) {
        long hours = duration.toHours();
        long minutes = duration.minusHours(hours).toMinutes();
        return I18n.getLabel("pending-approval.duration-since", hours, minutes);
    }

    @Override
    public Response approve(OnlinePlayer player, UUID uuid) {
        PlayerPendingApproval approval = this.playerPendingApprovalCache.getApprovalForPlayer(player, uuid);
        if (!approval.getSourcePlayer().isOnline()) {
            return ResponseFactory.fail(I18n.getLabel("player.not-online"));
        }
        Response response = approval.getRunnable().execute();
        approval.getFutureResponse().complete(response);
        this.playerPendingApprovalCache.removeApprovalForPlayer(player, approval);
        return ResponseFactory.success(I18n.getLabel("pending-approval.approved"));
    }

    @Override
    public Response deny(OnlinePlayer player, UUID uuid) {
        PlayerPendingApproval approval = this.playerPendingApprovalCache.getApprovalForPlayer(player, uuid);
        approval.getFutureResponse().complete(ResponseFactory.fail(I18n.getLabel("pending-approval.player-denied", player.getIgn(), approval.getMessage())));
        this.playerPendingApprovalCache.removeApprovalForPlayer(player, approval);
        return ResponseFactory.success(I18n.getLabel("pending-approval.denied"));
    }
}

