/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.ban;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.ban.BanSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.mod.ban.BanService;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BanServiceImpl
implements BanService {
    @Service
    private BanSession banSession;
    @Service
    private PlayerService playerService;
    private static final Pattern pattern = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");

    @Override
    public Response banPlayerOrIpAddress(String ignOrIpAddress, OnlinePlayer playerGivingBan, Integer days, String reason) {
        if (this.isIpAddress(ignOrIpAddress)) {
            this.banSession.banIpAddress(ignOrIpAddress, playerGivingBan, days, reason);
            return ResponseFactory.success(I18n.getLabel("ban.ip-address-ban.title"), I18n.getLabel("ban.ip-address-ban.success", ignOrIpAddress));
        }
        CorePlayer playerToBan = this.playerService.retrievePlayerByIgn(ignOrIpAddress);
        this.banSession.banPlayer(playerToBan, playerGivingBan, days, reason);
        return ResponseFactory.success(I18n.getLabel("ban.player-ban.title"), I18n.getLabel("ban.player-ban.success", playerToBan.getIgn()));
    }

    @Override
    public Response pardonPlayerOrIpAddress(String ignOrIpAddress) {
        if (this.isIpAddress(ignOrIpAddress)) {
            this.banSession.pardonIpAddress(ignOrIpAddress);
            return ResponseFactory.success(I18n.getLabel("ban.ip-address-pardon.title"), I18n.getLabel("ban.ip-address-pardon.success", ignOrIpAddress));
        }
        CorePlayer playerToPardon = this.playerService.retrievePlayerByIgn(ignOrIpAddress);
        this.banSession.pardonPlayer(playerToPardon);
        return ResponseFactory.success(I18n.getLabel("ban.player-pardon.title"), I18n.getLabel("ban.player-pardon.success", playerToPardon.getIgn()));
    }

    private boolean isIpAddress(String string) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }
}

