/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.bossbar;

import com.equestricraft.core.bossbar.BossBarService;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.bossbar.PlayerBossBarCache;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ComponentUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBossEventPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class BossBarServiceImpl
implements BossBarService {
    private final PlayerBossBarCache playerBossBarCache = PlayerBossBarCache.getInstance();

    @Override
    public void setBossBar(ECPlayer player, String text) {
        this.clearBossBar(player);
        ServerBossEvent event = new ServerBossEvent((Component)ComponentUtil.buildColoredTextComponent(text), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_6);
        UUID bossBarUuid = event.m_18860_();
        this.playerBossBarCache.set(player.getAccountUuid(), bossBarUuid);
        ClientboundBossEventPacket packet = ClientboundBossEventPacket.m_178639_((BossEvent)event);
        ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
        serverPlayer.f_8906_.m_141995_((Packet)packet);
    }

    @Override
    public void clearBossBar(ECPlayer player) {
        Optional<UUID> current = this.playerBossBarCache.get(player.getAccountUuid());
        if (current.isPresent()) {
            ClientboundBossEventPacket packet = ClientboundBossEventPacket.m_178641_((UUID)current.get());
            ServerPlayer serverPlayer = player.require(OnlinePlayer.class).serverPlayer();
            serverPlayer.f_8906_.m_141995_((Packet)packet);
            this.playerBossBarCache.remove(player.getAccountUuid());
        }
    }
}

