/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.bossbar;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;

public class PlayerBossBarCache {
    private static final PlayerBossBarCache instance = new PlayerBossBarCache();
    private final Map<UUID, UUID> playerBossBarMap = new HashMap<UUID, UUID>();
    private final StampedLock lock = new StampedLock();

    public static PlayerBossBarCache getInstance() {
        return instance;
    }

    private PlayerBossBarCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(UUID playerUuid, UUID bossBarUuid) {
        long stamp = this.lock.writeLock();
        try {
            this.playerBossBarMap.put(playerUuid, bossBarUuid);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<UUID> get(UUID playerUuid) {
        long stamp = this.lock.readLock();
        try {
            UUID bossBarUuid = this.playerBossBarMap.get(playerUuid);
            Optional<UUID> optional = Optional.ofNullable(bossBarUuid);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(UUID playerUuid) {
        long stamp = this.lock.writeLock();
        try {
            this.playerBossBarMap.remove(playerUuid);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

