/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.broadcast;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.broadcast.BroadcastService;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.ChatFormat;
import java.util.List;
import net.minecraft.network.chat.TextComponent;

public class BroadcastServiceImpl
implements BroadcastService {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    @Override
    public void broadcastMessage(String message) {
        TextComponent textComponent = new TextComponent(ChatFormat.formattingCodes(message));
        List<ECPlayer> players = this.onlinePlayerCache.getAllPlayers();
        for (ECPlayer player : players) {
            try {
                OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
                onlinePlayer.sendMessage(textComponent);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void broadcastMessageWithPrefix(String message) {
        String format = I18n.getLabel("broadcast.message", message);
        this.broadcastMessage(format);
    }

    @Override
    public void broadcastMessageImportant(String message) {
        String format = I18n.getLabel("broadcast.message.important", message);
        this.broadcastMessage(format);
    }

    @Override
    public void broadcastMessageWithPermission(String message, String permission) {
        TextComponent textComponent = new TextComponent(ChatFormat.formattingCodes(message));
        List<ECPlayer> players = this.onlinePlayerCache.getAllPlayers();
        for (ECPlayer player : players) {
            if (!player.hasPermission(permission)) continue;
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            onlinePlayer.sendMessage(textComponent);
        }
    }
}

