/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.bulletin;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.bulletin.BulletinInfo;
import com.equestricraft.core.bulletin.BulletinSession;
import com.equestricraft.core.player.bulletin.BulletinPlayerSession;
import com.equestricraft.mod.bulletin.BulletinService;
import com.equestricraft.mod.packet.ClientBoundShowBulletinPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.Optional;

public class BulletinServiceImpl
implements BulletinService {
    @Service
    private BulletinSession bulletinSession;
    @Service
    private BulletinPlayerSession bulletinPlayerSession;

    @Override
    public boolean showNextBulletinToPlayer(OnlinePlayer player) {
        Optional<BulletinInfo> bulletinToShow = this.bulletinSession.getBulletinToShowForPlayer(player);
        if (bulletinToShow.isPresent()) {
            ClientBoundShowBulletinPacket packet = new ClientBoundShowBulletinPacket(bulletinToShow.get());
            player.sendPacket(packet);
            return true;
        }
        return false;
    }

    @Override
    public void nextBulletin(OnlinePlayer player, int bulletinId) {
        this.bulletinSeenByPlayer(player, bulletinId);
        this.showNextBulletinToPlayer(player);
    }

    @Override
    public void bulletinSeenByPlayer(OnlinePlayer player, int bulletinId) {
        this.bulletinPlayerSession.markBulletinAsSeenByPlayer(bulletinId, player);
    }

    @Override
    public void showMostRecentBulletinToPlayer(OnlinePlayer player) {
        Optional<BulletinInfo> bulletinToShow = this.bulletinSession.getMostRecentBulletin();
        if (bulletinToShow.isPresent()) {
            ClientBoundShowBulletinPacket packet = new ClientBoundShowBulletinPacket(bulletinToShow.get());
            player.sendPacket(packet);
        }
    }
}

