/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.business;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.core.business.BusinessRepository;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.packet.ClientBoundBusinessSearchMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.PromptResponseHandler;
import com.equestricraft.mod.prompt.PromptResponsesHandler;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class BusinessSearchPrompt {
    @Service
    private static BusinessRepository businessRepository;
    private static final PromptResponsesHandler promptResponsesHandler;
    private static final Log log;

    public static Optional<Business> showBusinessSearchPrompt(OnlinePlayer player) {
        try {
            CompletableFuture<Business> result = BusinessSearchPrompt.showAsyncBusinessSearchPrompt(player);
            return Optional.ofNullable(result.get());
        }
        catch (ExecutionException ex) {
            log.error(String.format("Error with business search prompt. Player: %s", player.getIgn()), ex);
            return Optional.empty();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
    }

    public static CompletableFuture<Business> showAsyncBusinessSearchPrompt(OnlinePlayer player) {
        PromptResponseHandler handler = promptResponsesHandler.initResponse(player);
        ClientBoundBusinessSearchMenuOpenPacket packet = new ClientBoundBusinessSearchMenuOpenPacket(handler.uuid(), new BusinessPublicRegisterPage(Collections.emptyList(), 1, 1, SortDirection.ASCENDING, (Object)null, ""));
        player.sendPacket(packet);
        return handler.future().thenApply(id -> {
            if (id == null) {
                return null;
            }
            return (Business)businessRepository.findByKey(id);
        });
    }

    private BusinessSearchPrompt() {
    }

    static {
        promptResponsesHandler = PromptResponsesHandler.getInstance();
        log = Log.getLogger(BusinessSearchPrompt.class.getName());
    }
}

