/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.business;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.core.business.BusinessRegisterItem;
import com.equestricraft.core.business.InspectionStatus;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.mod.player.PlayerSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class BusinessSerializer {
    public static void serialize(BusinessPublicRegisterPage page, FriendlyByteBuf buffer) {
        buffer.writeInt(page.getItems().size());
        for (BusinessRegisterItem business : page.getItems()) {
            buffer.writeInt(business.businessId());
            buffer.m_130070_(business.name());
            buffer.writeInt(business.daysActive());
            PlayerSerializer.serializePlayerSimple(business.owner(), buffer);
            buffer.m_130068_((Enum)business.inspectionStatus());
            buffer.writeInt(business.categories().size());
            for (BusinessRegisterItem.BusinessRegisterItemCategory category : business.categories()) {
                buffer.writeInt(category.categoryId());
                buffer.m_130070_(category.categoryName());
            }
        }
        buffer.writeInt(page.getPageNumber());
        buffer.writeInt(page.getTotalPages());
        buffer.m_130068_((Enum)page.getSortDirection());
        if (page.getFilterObject() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_((String)page.getFilterObject());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public static BusinessPublicRegisterPage deserialize(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ArrayList<BusinessRegisterItem> businesses = new ArrayList<BusinessRegisterItem>(count);
        for (int i = 0; i < count; ++i) {
            int businessId = buffer.readInt();
            String businessName = buffer.m_130277_();
            int daysActive = buffer.readInt();
            PlayerSimple owner = PlayerSerializer.deserializePlayerSimple(buffer);
            InspectionStatus inspectionStatus = (InspectionStatus)buffer.m_130066_(InspectionStatus.class);
            int categoryCount = buffer.readInt();
            ArrayList<BusinessRegisterItem.BusinessRegisterItemCategory> categories = new ArrayList<BusinessRegisterItem.BusinessRegisterItemCategory>(categoryCount);
            for (int j = 0; j < categoryCount; ++j) {
                int categoryId = buffer.readInt();
                String categoryName = buffer.m_130277_();
                BusinessRegisterItem.BusinessRegisterItemCategory category = new BusinessRegisterItem.BusinessRegisterItemCategory(categoryId, categoryName);
                categories.add(category);
            }
            BusinessRegisterItem item = new BusinessRegisterItem(businessId, businessName, daysActive, owner, inspectionStatus, categories);
            businesses.add(item);
        }
        int pageNumber = buffer.readInt();
        int totalPages = buffer.readInt();
        SortDirection sortDirection = (SortDirection)buffer.m_130066_(SortDirection.class);
        String filterObject = buffer.readBoolean() ? buffer.m_130277_() : null;
        return new BusinessPublicRegisterPage((List<BusinessRegisterItem>)businesses, pageNumber, totalPages, sortDirection, (Object)null, filterObject);
    }

    private BusinessSerializer() {
    }
}

