/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.business;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.business.Business;
import com.equestricraft.core.business.BusinessListItem;
import com.equestricraft.core.business.BusinessPublicRegisterPage;
import com.equestricraft.core.business.BusinessPublicRegisterPageSession;
import com.equestricraft.core.business.BusinessRepository;
import com.equestricraft.core.business.BusinessSession;
import com.equestricraft.core.business.category.BusinessCategory;
import com.equestricraft.core.business.category.BusinessCategoryRepository;
import com.equestricraft.core.business.invoice.BusinessInvoice;
import com.equestricraft.core.business.invoice.BusinessInvoiceSession;
import com.equestricraft.core.business.registration.BusinessRegistrationRequest;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestDto;
import com.equestricraft.core.business.registration.BusinessRegistrationRequestSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.business.BusinessCategoryDto;
import com.equestricraft.mod.business.BusinessSearchPrompt;
import com.equestricraft.mod.business.BusinessSelectAction;
import com.equestricraft.mod.business.BusinessService;
import com.equestricraft.mod.packet.ClientBoundBusinessItemListPacket;
import com.equestricraft.mod.packet.ClientBoundBusinessMainMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundBusinessRegisterBusinessMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundBusinessRegisterMenuOpenPacket;
import com.equestricraft.mod.packet.ClientBoundBusinessSearchMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.NumberInputPrompt;
import com.equestricraft.mod.prompt.PlayerSearchPrompt;
import com.equestricraft.mod.prompt.TextInputPrompt;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class BusinessServiceImpl
implements BusinessService {
    @Service
    private BusinessSession businessSession;
    @Service
    private BusinessRepository businessRepository;
    @Service
    private BusinessCategoryRepository businessCategoryRepository;
    @Service
    private BusinessInvoiceSession businessInvoiceSession;
    @Service
    private BusinessPublicRegisterPageSession businessPublicRegisterPageSession;
    @Service
    private BusinessRegistrationRequestSession businessRegistrationRequestSession;

    @Override
    public void showBusinessRegistrationMenu(OnlinePlayer player) {
        List<BusinessCategory> categories = this.businessCategoryRepository.findAllEnabled();
        List<BusinessCategoryDto> categoryDtos = categories.stream().map(this::toDto).toList();
        ClientBoundBusinessRegisterBusinessMenuOpenPacket packet = new ClientBoundBusinessRegisterBusinessMenuOpenPacket(categoryDtos);
        player.sendPacket(packet);
    }

    private BusinessCategoryDto toDto(BusinessCategory businessCategory) {
        return new BusinessCategoryDto(businessCategory.getId(), businessCategory.getName(), businessCategory.getDescription());
    }

    @Override
    public Response registerBusiness(OnlinePlayer player, BusinessRegistrationRequestDto registrationRequest) {
        BusinessRegistrationRequest newRequest = this.businessRegistrationRequestSession.createNewRequest(player, registrationRequest);
        return ResponseFactory.success(I18n.getLabel("business.request-sent", newRequest.getId()));
    }

    @Override
    public void showBusinessMenu(ECPlayer player) {
        ClientBoundBusinessMainMenuOpenPacket packet = new ClientBoundBusinessMainMenuOpenPacket(true);
        player.sendPacket(packet);
    }

    @Override
    public void processMenuRequest(OnlinePlayer player, int menu) {
        switch (menu) {
            case 1: {
                this.showBusinessRegisterMenu(player);
                break;
            }
            case 2: {
                this.showMyBusinessesMenu(player);
                break;
            }
            case 3: {
                this.showBusinessRegistrationMenu(player);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid menu identifier: %s", menu));
            }
        }
    }

    private void showBusinessRegisterMenu(OnlinePlayer player) {
        this.showBusinessRegisterPage(player, 1);
    }

    @Override
    public void showBusinessRegisterPage(OnlinePlayer player, int pageNumber) {
        BusinessPublicRegisterPage businesses = this.businessPublicRegisterPageSession.retrievePage(pageNumber);
        ClientBoundBusinessRegisterMenuOpenPacket packet = new ClientBoundBusinessRegisterMenuOpenPacket(businesses);
        player.sendPacket(packet);
    }

    private void showMyBusinessesMenu(OnlinePlayer player) {
        List<BusinessListItem> playersBusinesses = this.businessSession.retrievePlayersOwnedBusinessList(player);
        ClientBoundBusinessItemListPacket packet = new ClientBoundBusinessItemListPacket(playersBusinesses, BusinessSelectAction.SHOW_EDIT_MENU);
        player.sendPacket(packet);
    }

    @Override
    public Response showCreateInvoiceToPlayerMenu(ECPlayer player) {
        List<BusinessListItem> businesses = this.businessSession.retrievePlayersOwnedBusinessList(player);
        ClientBoundBusinessItemListPacket packet = new ClientBoundBusinessItemListPacket(businesses, BusinessSelectAction.CREATE_PLAYER_INVOICE);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public Response showCreateInvoiceToBusinessMenu(ECPlayer player) {
        List<BusinessListItem> businesses = this.businessSession.retrievePlayersOwnedBusinessList(player);
        ClientBoundBusinessItemListPacket packet = new ClientBoundBusinessItemListPacket(businesses, BusinessSelectAction.CREATE_BUSINESS_INVOICE);
        player.sendPacket(packet);
        return ResponseFactory.success();
    }

    @Override
    public void showBusinessSelectPage(OnlinePlayer player, UUID requestId, int pageNumber, String searchTerms) {
        BusinessPublicRegisterPage page = this.businessPublicRegisterPageSession.retrievePage(pageNumber, searchTerms);
        ClientBoundBusinessSearchMenuOpenPacket packet = new ClientBoundBusinessSearchMenuOpenPacket(requestId, page);
        player.sendPacket(packet);
    }

    @Override
    public void processBusinessListMenuSelect(OnlinePlayer player, int businessId, BusinessSelectAction action) {
        Business business = (Business)this.businessRepository.findByKey(businessId);
        switch (action) {
            case CREATE_PLAYER_INVOICE: {
                this.executeCreatePlayerInvoiceAction(player, business);
                break;
            }
            case CREATE_BUSINESS_INVOICE: {
                this.executeCreateBusinessInvoiceAction(player, business);
                break;
            }
            case SHOW_EDIT_MENU: {
                this.showEditMenu(player, business);
            }
        }
    }

    private int executeCreatePlayerInvoiceAction(OnlinePlayer player, Business business) {
        InvoiceDetails details = this.captureInvoiceDetails(player);
        Optional<ECPlayer> selectedPlayer = PlayerSearchPrompt.showPlayerSearchPrompt(player);
        if (selectedPlayer.isPresent()) {
            BusinessInvoice invoice = this.businessInvoiceSession.createInvoice(business, selectedPlayer.get(), details.description(), details.value());
            return invoice.getInvoiceNumber();
        }
        return 0;
    }

    private int executeCreateBusinessInvoiceAction(OnlinePlayer player, Business business) {
        InvoiceDetails details = this.captureInvoiceDetails(player);
        Optional<Business> selectedBusiness = BusinessSearchPrompt.showBusinessSearchPrompt(player);
        if (selectedBusiness.isPresent()) {
            BusinessInvoice invoice = this.businessInvoiceSession.createInvoice(business, selectedBusiness.get(), details.description(), details.value());
            return invoice.getInvoiceNumber();
        }
        return 0;
    }

    private InvoiceDetails captureInvoiceDetails(OnlinePlayer player) {
        String details = TextInputPrompt.showTextInputPrompt(player, I18n.getLabel("business.create-invoice.prompt.title"), I18n.getLabel("business.create-invoice.prompt.enter-invoice-details")).orElseThrow();
        Number value = NumberInputPrompt.showNumberInputPrompt(player, I18n.getLabel("business.create-invoice.prompt.title"), I18n.getLabel("business.create-invoice.prompt.enter-invoice-value")).orElseThrow();
        return new InvoiceDetails(details, value.doubleValue());
    }

    private void showEditMenu(OnlinePlayer player, Business business) {
    }

    private record InvoiceDetails(String description, double value) {
    }
}

