/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.chat;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.chatcommandlog.ChatCommandLogService;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.mod.afk.AfkService;
import com.equestricraft.mod.chat.channel.ChatChannel;
import com.equestricraft.mod.chat.channel.ChatChannelProvider;
import com.equestricraft.mod.chat.channel.GlobalChannel;
import com.equestricraft.mod.chat.format.ChatFormatService;
import com.equestricraft.mod.packet.ClientBoundECChatPacket;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.DEDICATED_SERVER})
public class ChatListener {
    @Service
    private static ChatFormatService chatFormatService;
    @Service
    private static ChatCommandLogService chatCommandLogService;
    @Service
    private static AfkService afkService;
    @Service
    private static ServiceInstance<ChatChannelProvider> chatChannelProviders;
    private static final OnlinePlayerCache onlinePlayerCache;
    private static final GlobalChannel globalChannel;

    @SubscribeEvent(receiveCanceled=false)
    public static void onChat(ServerChatEvent event) {
        List<ECPlayer> players;
        TextItem textItem;
        String message = event.getMessage();
        ECPlayer player = onlinePlayerCache.requirePlayer(event.getPlayer().m_142081_());
        afkService.clearAfk(player);
        if (player.chatDisabled()) {
            player.sendMessage(I18n.getLabel("chat.disabled"));
            event.setCanceled(true);
            return;
        }
        chatCommandLogService.logChat(player.getId(), message);
        Optional<ChatChannel> playersChannel = ChatListener.getPlayersActiveChannel(player);
        if (playersChannel.isPresent()) {
            textItem = chatFormatService.buildChatTextComponent(playersChannel.get(), player, message);
            players = playersChannel.get().getPlayers();
        } else {
            textItem = chatFormatService.buildChatTextComponent(globalChannel, player, message);
            players = onlinePlayerCache.getAllPlayers().stream().filter(Predicate.not(ECPlayer::chatDisabled)).toList();
        }
        ClientBoundECChatPacket packet = new ClientBoundECChatPacket(player.getAccountUuid(), textItem);
        players.forEach(p -> p.sendPacket(packet));
        event.setCanceled(true);
    }

    private static Optional<ChatChannel> getPlayersActiveChannel(ECPlayer player) {
        return chatChannelProviders.stream().flatMap(ChatChannelProvider::getChatChannels).sorted(Comparator.comparing(ChatChannel::getPriority)).filter(p -> p.isPlayerIn(player)).findFirst();
    }

    private ChatListener() {
    }

    static {
        onlinePlayerCache = OnlinePlayerCache.getInstance();
        globalChannel = new GlobalChannel();
    }
}

