/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.chat.format;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.Argb;
import com.equestricraft.common.DateFormatter;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.chattag.ChatTag;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionRank;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.rank.Rank;
import com.equestricraft.core.university.house.UniversityHouse;
import com.equestricraft.mod.chat.channel.ChatChannel;
import com.equestricraft.mod.chat.format.ChatFormatService;
import com.equestricraft.mod.permission.GroupInfo;
import com.equestricraft.mod.permission.PermissionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ChatFormatServiceImpl
implements ChatFormatService {
    @Service
    private PermissionService permissionService;
    private static final TextItem chatMessagePrefix = new TextItem("&r >> ");
    private static final TextItem bracketsOpen = new TextItem("&f&l[&r");
    private static final TextItem bracketsClose = new TextItem("&f&l]&r");

    @Override
    public TextItem buildChatTextComponent(ChatChannel channel, ECPlayer player, String message) {
        ArrayList<TextItem> components = new ArrayList<TextItem>();
        Optional<TextItem> channelComponent = this.buildChannelComponent(channel);
        channelComponent.ifPresent(components::add);
        Optional<TextItem> tag = this.buildChatTagComponent(player);
        tag.ifPresent(components::add);
        Optional<TextItem> house = this.buildUniversityHouseComponent(player);
        house.ifPresent(components::add);
        Optional<TextItem> club = this.buildClubComponent(player);
        club.ifPresent(components::add);
        Optional<TextItem> faction = this.buildFactionComponent(player);
        faction.ifPresent(components::add);
        Optional<TextItem> job = this.buildJobComponent(player);
        job.ifPresent(components::add);
        components.add(this.buildRankComponent(player));
        components.add(this.buildDisplayNameComponent(player));
        components.add(chatMessagePrefix);
        components.add(new TextItem(message));
        return this.combineComponents(components);
    }

    private Optional<TextItem> buildChannelComponent(ChatChannel channel) {
        TextItem textItem = new TextItem(channel.getPrefix());
        return Optional.of(this.attachBrackets(textItem));
    }

    private Optional<TextItem> buildChatTagComponent(ECPlayer player) {
        Optional<ChatTag> tag = player.getChatTag().getCurrent();
        if (tag.isPresent()) {
            TextItem component = new TextItem(tag.get().getText());
            this.attachHoverText(component, tag.get().getDescription());
            return Optional.of(this.attachBrackets(component));
        }
        return Optional.empty();
    }

    private Optional<TextItem> buildUniversityHouseComponent(ECPlayer player) {
        Optional<UniversityHouse> house = player.getUniversity().getHouse();
        if (house.isPresent()) {
            TextItem component = new TextItem(house.get().getChatTag());
            this.attachHoverText(component, house.get().getName());
            return Optional.of(this.attachBrackets(component));
        }
        return Optional.empty();
    }

    private Optional<TextItem> buildClubComponent(ECPlayer player) {
        Optional<Club> club = player.getClub().getClub();
        if (club.isPresent()) {
            TextItem component = new TextItem(club.get().getChatTag());
            this.attachHoverText(component, club.get().getName() + "\n" + player.getClub().getRankLabel());
            return Optional.of(this.attachBrackets(component));
        }
        return Optional.empty();
    }

    private Optional<TextItem> buildFactionComponent(ECPlayer player) {
        Optional<Faction> faction = player.getFaction().getFaction();
        if (faction.isPresent()) {
            Faction f = faction.get();
            TextItem component = new TextItem(f.getChatTag());
            component.setColor(f.getColor());
            FactionRank rank = player.getFaction().getRank().orElseThrow();
            this.attachHoverText(component, rank.getName() + "\n" + rank.getDescription());
            return Optional.of(this.attachBrackets(component));
        }
        return Optional.empty();
    }

    private Optional<TextItem> buildJobComponent(ECPlayer player) {
        Optional<Job> job = player.getJob().getCurrent();
        if (job.isPresent()) {
            TextItem component = new TextItem(job.get().getChatTag());
            this.attachColor(component, job.get().getColor());
            JobRank rank = player.getJob().getRank().orElseThrow();
            this.attachHoverText(component, job.get().getName() + "\n" + rank.getName() + "\n");
            return Optional.of(this.attachBrackets(component));
        }
        return Optional.empty();
    }

    private TextItem buildRankComponent(ECPlayer player) {
        TextItem component;
        GroupInfo group = this.permissionService.getPlayersPrimaryGroup(player);
        if (group.prefix() != null) {
            component = new TextItem(group.prefix());
        } else {
            Rank rank = player.getProgression().getRank();
            component = new TextItem(rank.getName());
            this.attachColor(component, rank.getColor());
        }
        this.attachHoverText(component, I18n.getLabel("chat-format.rank.hover.xp", player.getCorePlayer().getXp()));
        return this.attachBrackets(component);
    }

    private TextItem buildDisplayNameComponent(ECPlayer player) {
        TextItem displayName = player.getDisplayName();
        TextItem component = new TextItem();
        component.addChildItem(displayName);
        this.attachHoverText(component, this.buildDisplayNameHover(player));
        return component;
    }

    private String buildDisplayNameHover(ECPlayer player) {
        return player.getIgn() + "\n" + I18n.getLabel("chat-format.first-join", DateFormatter.formatDateDateMonthYear(player.getCorePlayer().getFirstSeen()));
    }

    private TextItem attachBrackets(TextItem component) {
        return this.combineComponents(bracketsOpen, component, bracketsClose);
    }

    private void attachColor(TextItem component, Argb color) {
        if (color == null) {
            return;
        }
        component.setColor(color);
    }

    private void attachHoverText(TextItem component, String hoverText) {
        if (hoverText == null) {
            return;
        }
        component.setHoverItem(new TextItem(hoverText));
    }

    private TextItem combineComponents(TextItem ... components) {
        TextItem component = new TextItem(StringUtils.emptyString());
        for (TextItem comp : components) {
            component.addChildItem(comp);
        }
        return component;
    }

    private TextItem combineComponents(List<TextItem> components) {
        TextItem component = new TextItem(StringUtils.emptyString());
        for (TextItem comp : components) {
            component.addChildItem(comp);
        }
        return component;
    }
}

