/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.chattag;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.chattag.ChatTag;
import com.equestricraft.core.chattag.ChatTagRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerAccessSession;
import com.equestricraft.mod.chattag.ChatTagItem;
import com.equestricraft.mod.chattag.ChatTagPage;
import com.equestricraft.mod.chattag.ChatTagPageService;
import java.util.Comparator;
import java.util.List;

public class ChatTagPageServiceImpl
extends Pagination<ChatTagItem, ChatTagPage, Object, Object>
implements ChatTagPageService {
    @Service
    private ChatTagRepository chatTagRepository;
    @Service
    private ChatTagPlayerAccessSession chatTagPlayerAccessSession;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public ChatTagPage retrieveChatTagPage(ECPlayer player, int pageNumber) {
        List<ChatTagItem> items = this.chatTagRepository.streamAll().filter(c -> this.canPlayerUseTag(player, (ChatTag)c)).map(c -> this.buildItem(player, (ChatTag)c)).toList();
        return (ChatTagPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private boolean canPlayerUseTag(ECPlayer player, ChatTag chatTag) {
        return this.chatTagPlayerAccessSession.canPlayerAccessTag(player, chatTag.getId());
    }

    private ChatTagItem buildItem(ECPlayer player, ChatTag chatTag) {
        boolean active = player.getCorePlayer().getActiveTagId() != null && player.getCorePlayer().getActiveTagId().intValue() == chatTag.getId();
        return new ChatTagItem(chatTag.getId(), chatTag.getName(), chatTag.getDescription(), chatTag.getText(), active);
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(ChatTagItem item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<ChatTagItem> compare(Object sortOrderObject) {
        return Comparator.comparing(ChatTagItem::name);
    }

    @Override
    protected ChatTagPage buildPage(List<ChatTagItem> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new ChatTagPage(items, pageNumber, totalPages, sortDirection);
    }
}

