/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.chattag;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.chattag.ChatTag;
import com.equestricraft.core.chattag.ChatTagRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerAccessSession;
import com.equestricraft.mod.chattag.ChatTagPage;
import com.equestricraft.mod.chattag.ChatTagPageService;
import com.equestricraft.mod.chattag.ChatTagService;
import com.equestricraft.mod.packet.ClientBoundChatTagMenuOpenPacket;
import java.util.UUID;

public class ChatTagServiceImpl
implements ChatTagService {
    @Service
    private ChatTagPageService chatTagPageService;
    @Service
    private ChatTagRepository chatTagRepository;
    @Service
    private ChatTagPlayerAccessSession chatTagPlayerAccessSession;
    @Service
    private PlayerService playerService;

    @Override
    public void showChatTagMenu(ECPlayer player) {
        this.showChatTagMenu(player, 1);
    }

    @Override
    public void showChatTagMenu(ECPlayer player, int pageNumber) {
        ChatTagPage page = this.chatTagPageService.retrieveChatTagPage(player, pageNumber);
        ClientBoundChatTagMenuOpenPacket packet = new ClientBoundChatTagMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    @Override
    public Response setActiveChatTag(ECPlayer player, int tagId) {
        ChatTag tag = (ChatTag)this.chatTagRepository.findByKey(tagId);
        player.getChatTag().setCurrent(tag);
        return ResponseFactory.success(I18n.getLabel("chat-tags.set"));
    }

    @Override
    public Response removeChatTag(ECPlayer player) {
        player.getChatTag().clearCurrent();
        return ResponseFactory.success(I18n.getLabel("chat-tags.removed"));
    }

    @Override
    public Response grantAccessToChatTag(UUID playerToGrantUuid, int tagId) {
        CorePlayer player = this.playerService.retrievePlayerByAccountUuid(playerToGrantUuid);
        this.chatTagPlayerAccessSession.grantPlayerAccessToTag(player, tagId);
        return ResponseFactory.success();
    }

    @Override
    public Response revokeAccessFromChatTag(UUID playerToRevokeUuid, int tagId) {
        CorePlayer player = this.playerService.retrievePlayerByAccountUuid(playerToRevokeUuid);
        this.chatTagPlayerAccessSession.revokePlayerAccessFromTag(player, tagId);
        return ResponseFactory.success();
    }
}

