/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.chattag;

import com.equestricraft.base.response.Response;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.chattag.ChatTagService;
import com.equestricraft.mod.command.Arg;
import com.equestricraft.mod.command.Async;
import com.equestricraft.mod.command.Command;
import com.equestricraft.mod.command.Permission;
import com.equestricraft.mod.context.ModPlayerContext;
import java.util.UUID;

@Command(value="chat-tag")
public class ChatTagsCommand {
    @Service
    private ChatTagService chatTagService;

    @Async
    @Command
    public void onCommand() {
        ECPlayer player = ModPlayerContext.getPlayer();
        this.chatTagService.showChatTagMenu(player);
    }

    @Async
    @Command(value="remove")
    public Response onRemove() {
        ECPlayer player = ModPlayerContext.getPlayer();
        return this.chatTagService.removeChatTag(player);
    }

    @Async
    @Command(value="grant")
    @Permission(value="equestricraft.chat-tag.admin")
    public Response grant(@Arg String playerUuid, @Arg int tagId) {
        return this.chatTagService.grantAccessToChatTag(UUID.fromString(playerUuid), tagId);
    }

    @Async
    @Command(value="revoke")
    @Permission(value="equestricraft.chat-tag.admin")
    public Response revoke(@Arg String playerUuid, @Arg int tagId) {
        return this.chatTagService.revokeAccessFromChatTag(UUID.fromString(playerUuid), tagId);
    }
}

