/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client;

import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.mod.client.MobEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;

public interface ECNpc
extends MobEntity {
    public int getInternalId();

    public boolean isNpc();

    public void setInternalId(int var1);

    public void setBaseSpeed(float var1);

    public CompoundTag getVisibilitySettingsTag();

    public void setVisibilitySettingsTag(CompoundTag var1);

    default public CompoundTag createDefaultTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("global", true);
        tag.m_128359_("hidden_players", "");
        return tag;
    }

    default public void setAsGlobal() {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        tag.m_128379_("global", true);
        tag.m_128473_("private_player_uuid");
        this.setVisibilitySettingsTag(tag);
    }

    default public void setPrivateForPlayer(ECPlayer player) {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        tag.m_128379_("global", false);
        tag.m_128362_("private_player_uuid", player.getAccountUuid());
        this.setVisibilitySettingsTag(tag);
    }

    default public UUID getPrivatePlayerUuid() {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        if (!tag.m_128471_("global")) {
            return tag.m_128342_("private_player_uuid");
        }
        return null;
    }

    default public boolean isGlobal() {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        return tag.m_128471_("global");
    }

    default public boolean isPrivateForPlayer() {
        return !this.isGlobal();
    }

    default public void hideGlobalFromPlayer(ECPlayer player) {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        if (tag.m_128471_("global")) {
            String hiddenPlayers = tag.m_128461_("hidden_players");
            List<UUID> list = this.toList(hiddenPlayers);
            list.add(player.getAccountUuid());
            String string = list.stream().map(UUID::toString).collect(Collectors.joining(","));
            tag.m_128359_("hidden_players", string);
            this.setVisibilitySettingsTag(tag);
        }
    }

    default public void showGlobalToPlayer(ECPlayer player) {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        if (tag.m_128471_("global")) {
            String hiddenPlayers = tag.m_128461_("hidden_players");
            List<UUID> list = this.toList(hiddenPlayers);
            list.remove(player.getAccountUuid());
            String string = list.stream().map(UUID::toString).collect(Collectors.joining(","));
            tag.m_128359_("hidden_players", string);
            this.setVisibilitySettingsTag(tag);
        }
    }

    private List<UUID> toList(String string) {
        if (string.isEmpty()) {
            return new ArrayList<UUID>(0);
        }
        String[] arr = string.split(",");
        ArrayList<UUID> list = new ArrayList<UUID>(arr.length);
        for (String uuid : arr) {
            list.add(UUID.fromString(uuid));
        }
        return list;
    }

    default public boolean shouldHide(UUID playerUuid) {
        if (this.isGlobal()) {
            return this.isOnHiddenList(playerUuid);
        }
        return !this.getPrivatePlayerUuid().equals(playerUuid);
    }

    default public boolean isOnHiddenList(UUID playerUuid) {
        CompoundTag tag = this.getVisibilitySettingsTag().m_6426_();
        if (tag.m_128471_("global")) {
            String hiddenPlayersString = tag.m_128461_("hidden_players");
            List<UUID> list = this.toList(hiddenPlayersString);
            return list.contains(playerUuid);
        }
        return false;
    }
}

