/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class MobFollowPlayerGoal<T extends Mob>
extends Goal {
    protected final T mob;
    private ServerPlayer playerToFollow = null;
    protected double maximumSpeed = 0.0;

    protected MobFollowPlayerGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public void setFollow(ServerPlayer playerToFollow, double maximumSpeed) {
        this.playerToFollow = playerToFollow;
        this.maximumSpeed = maximumSpeed;
    }

    public void stopFollow() {
        this.maximumSpeed = 0.0;
    }

    public boolean isActive() {
        return this.maximumSpeed > 0.0 && this.playerToFollow != null;
    }

    public ServerPlayer getPlayerToFollow() {
        return this.playerToFollow;
    }

    public boolean m_8036_() {
        return this.isActive();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (!this.isNearPlayer()) {
            Vec3 playerLocation = this.playerToFollow.m_20182_();
            this.mob.m_21566_().m_6849_(playerLocation.m_7096_(), playerLocation.m_7098_(), playerLocation.m_7094_(), this.determineSpeed());
            if (this.needsToJump()) {
                this.mob.m_21569_().m_24901_();
            }
        } else {
            this.onNotNearTarget();
        }
    }

    protected void onNotNearTarget() {
    }

    public void m_8041_() {
        this.playerToFollow = null;
        this.maximumSpeed = 0.0;
        this.mob.m_21573_().m_26573_();
    }

    protected abstract double determineSpeed();

    protected final double getDistance() {
        Vec3 mobPos = this.mob.m_20182_();
        Vec3 playerPos = this.playerToFollow.m_20182_();
        return mobPos.m_82554_(playerPos);
    }

    private boolean needsToJump() {
        BlockPos blocksAheadOnTop = this.getAheadOnTop();
        return !this.isBlockWalkable(this.getStateForPos(blocksAheadOnTop));
    }

    private BlockPos getAheadOnTop() {
        BlockPos blockAhead = this.mob.m_20097_().m_141952_(this.mob.m_6350_().m_122436_());
        return blockAhead.m_141952_(Direction.UP.m_122436_());
    }

    private boolean isBlockWalkable(BlockState blockState) {
        return blockState.m_60767_().m_76336_() || !blockState.m_60767_().m_76334_();
    }

    private BlockState getStateForPos(BlockPos blockPos) {
        return this.mob.m_183503_().m_8055_(blockPos);
    }

    private boolean isNearPlayer() {
        Vec3 playerPos;
        Vec3 mobPos = this.mob.m_20182_();
        double distance = mobPos.m_82554_(playerPos = this.playerToFollow.m_20182_());
        return distance < 3.0;
    }
}

