/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.mod.client.MobWaypointDistancePolicy;
import com.equestricraft.mod.player.OnlinePlayer;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public abstract class MobWaypointFollowGoal<T extends Mob>
extends Goal {
    protected final T mob;
    private Vec3 waypoint = null;
    private double speed = 0.2;
    private Runnable onReachAction = null;
    private OnlinePlayer player = null;
    private MobWaypointDistancePolicy minimumDistancePolicy;
    private MobWaypointDistancePolicy maximumDistancePolicy;
    private Long limitBreachStartTime = null;

    protected MobWaypointFollowGoal(T mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public void setWaypoint(Vec3 waypoint, double speed, Runnable onReachAction) {
        this.waypoint = waypoint;
        this.speed = speed;
        this.onReachAction = onReachAction;
        this.mob.m_21573_().m_26573_();
        this.setPathfindingTarget(waypoint);
        this.setSpeed();
    }

    protected void setSpeed() {
    }

    public void setPlayer(OnlinePlayer player, MobWaypointDistancePolicy minimumDistancePolicy, MobWaypointDistancePolicy maximumDistancePolicy) {
        this.player = player;
        this.minimumDistancePolicy = minimumDistancePolicy;
        this.maximumDistancePolicy = maximumDistancePolicy;
    }

    public boolean m_8036_() {
        return this.waypoint != null;
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26573_();
        this.setPathfindingTarget(this.waypoint);
    }

    public void m_8037_() {
        Vec3 currentWaypoint = this.waypoint;
        if (currentWaypoint != null) {
            if (this.isMinimumDistancePolicyTrue() || this.isMaximumDistancePolicyTrue()) {
                this.mob.m_21573_().m_26573_();
                return;
            }
            if (this.limitBreachStartTime != null) {
                this.setPathfindingTarget(currentWaypoint);
                this.limitBreachStartTime = null;
            }
            this.checkAndClearPathIfPossible();
            if (this.needsToJump()) {
                this.mob.m_21569_().m_24901_();
            }
            if (this.mob.m_21573_().m_26577_()) {
                this.setPathfindingTarget(currentWaypoint);
            }
            if (this.mob.m_21573_().m_26571_()) {
                if (this.hasReachedWaypoint()) {
                    this.mob.m_21573_().m_26573_();
                    this.resetGoal();
                    this.m_8041_();
                } else {
                    this.mob.m_21566_().m_6849_(currentWaypoint.m_7096_(), currentWaypoint.m_7098_(), currentWaypoint.m_7094_(), this.speed);
                }
            }
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    private void setPathfindingTarget(Vec3 waypoint) {
        if (waypoint != null) {
            this.mob.m_21573_().m_26573_();
            Path path = this.mob.m_21573_().m_26524_(waypoint.m_7096_(), waypoint.m_7098_(), waypoint.m_7094_(), 0);
            this.mob.m_21573_().m_26536_(path, this.speed);
        }
    }

    protected void resetGoal() {
        this.waypoint = null;
        this.speed = 0.0;
        Runnable fReachAction = this.onReachAction;
        this.onReachAction = null;
        this.player = null;
        this.minimumDistancePolicy = null;
        this.maximumDistancePolicy = null;
        if (fReachAction != null) {
            fReachAction.run();
        }
    }

    private void checkAndClearPathIfPossible() {
        BlockPos center = this.getAheadOnTop();
        LeftRightPair leftAndRightForMob = this.determineLeftAndRightForMob();
        BlockPos left = center.m_141952_(leftAndRightForMob.leftDirection().m_122436_());
        BlockPos right = center.m_141952_(leftAndRightForMob.rightDirection().m_122436_());
        this.checkBlockForDoor(center);
        this.checkBlockForDoor(left);
        this.checkBlockForDoor(right);
        this.checkBlockForFenceGate(center);
        this.checkBlockForFenceGate(left);
        this.checkBlockForFenceGate(right);
    }

    private LeftRightPair determineLeftAndRightForMob() {
        return switch (this.mob.m_6350_()) {
            case Direction.NORTH -> new LeftRightPair(Direction.WEST, Direction.EAST);
            case Direction.SOUTH -> new LeftRightPair(Direction.EAST, Direction.WEST);
            case Direction.EAST -> new LeftRightPair(Direction.NORTH, Direction.SOUTH);
            case Direction.WEST -> new LeftRightPair(Direction.SOUTH, Direction.NORTH);
            default -> throw new IllegalArgumentException(String.format("Illegal direction: %s", this.mob.m_6350_()));
        };
    }

    private void checkBlockForDoor(BlockPos pos) {
        DoorBlock doorBlock;
        BlockState blockState = this.getStateForPos(pos);
        Block block = blockState.m_60734_();
        if (block instanceof DoorBlock && !(doorBlock = (DoorBlock)block).m_52815_(blockState)) {
            doorBlock.m_153165_(this.mob, this.mob.m_183503_(), blockState, pos, true);
        }
    }

    private void checkBlockForFenceGate(BlockPos pos) {
        BlockPos inFrontOfGatePos;
        BlockState blockInFront;
        BlockState blockState = this.getStateForPos(pos);
        if (blockState.m_60734_() instanceof FenceGateBlock && Boolean.FALSE.equals(blockState.m_61143_((Property)FenceGateBlock.f_53341_)) && this.isBlockWalkable(blockInFront = this.getStateForPos(inFrontOfGatePos = pos.m_141952_(this.mob.m_6350_().m_122424_().m_122436_())))) {
            this.mob.m_183503_().m_46597_(pos, (BlockState)blockState.m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean needsToJump() {
        BlockPos blockAheadOnTop = this.getAheadOnTop();
        return !this.isBlockWalkable(this.getStateForPos(blockAheadOnTop));
    }

    private BlockPos getAheadOnTop() {
        BlockPos blockAhead = this.mob.m_20097_().m_141952_(this.mob.m_6350_().m_122436_());
        return blockAhead.m_141952_(Direction.UP.m_122436_());
    }

    private boolean isBlockWalkable(BlockState blockState) {
        return blockState.m_60767_().m_76336_() || !blockState.m_60767_().m_76334_();
    }

    private boolean isMinimumDistancePolicyTrue() {
        MobWaypointDistancePolicy fPolicy = this.minimumDistancePolicy;
        if (fPolicy == null) {
            return false;
        }
        if (this.isPlayerTooClose(fPolicy.distance())) {
            if (!this.isAtLimitBreach() && fPolicy.hasInitialAction()) {
                this.limitBreachStartTime = System.currentTimeMillis();
                fPolicy.initialAction().run();
            }
            if (fPolicy.hasAction() && this.isAtLimitBreach() && DateUtils.millisSince(this.limitBreachStartTime) > fPolicy.timeLimit().toMillis()) {
                fPolicy.action().run();
            }
            return true;
        }
        return false;
    }

    private boolean isPlayerTooClose(int distanceLimit) {
        Vec3 playerPos;
        OnlinePlayer fPlayer = this.player;
        if (fPlayer == null) {
            return false;
        }
        Vec3 mobPos = this.mob.m_20182_();
        double distance = mobPos.m_82554_(playerPos = this.player.serverPlayer().m_20182_());
        return distance < (double)distanceLimit;
    }

    private boolean isMaximumDistancePolicyTrue() {
        MobWaypointDistancePolicy fPolicy = this.maximumDistancePolicy;
        if (fPolicy == null) {
            return false;
        }
        if (this.isPlayerTooFar(fPolicy.distance())) {
            if (!this.isAtLimitBreach() && fPolicy.hasInitialAction()) {
                this.limitBreachStartTime = System.currentTimeMillis();
                fPolicy.initialAction().run();
            }
            if (fPolicy.hasAction() && this.isAtLimitBreach() && DateUtils.millisSince(this.limitBreachStartTime) > fPolicy.timeLimit().toMillis()) {
                fPolicy.action().run();
            }
            return true;
        }
        return false;
    }

    private boolean isPlayerTooFar(int distanceLimit) {
        Vec3 playerPos;
        OnlinePlayer fPlayer = this.player;
        if (fPlayer == null) {
            return false;
        }
        Vec3 mobPos = this.mob.m_20182_();
        double distance = mobPos.m_82554_(playerPos = this.player.serverPlayer().m_20182_());
        return distance > (double)distanceLimit;
    }

    private boolean isAtLimitBreach() {
        return this.limitBreachStartTime != null;
    }

    private double getGroundY(Vec3 vec) {
        BlockPos blockPos = new BlockPos(vec);
        return this.getStateForPos(blockPos.m_7495_()).m_60795_() ? vec.f_82480_ : WalkNodeEvaluator.m_77611_((BlockGetter)this.mob.m_183503_(), (BlockPos)blockPos);
    }

    private BlockState getStateForPos(BlockPos blockPos) {
        return this.mob.m_183503_().m_8055_(blockPos);
    }

    private boolean hasReachedWaypoint() {
        double x1 = this.mob.m_20182_().f_82479_;
        double z1 = this.mob.m_20182_().f_82481_;
        double x2 = this.waypoint.f_82479_;
        double z2 = this.waypoint.f_82481_;
        double dx = Math.abs(x1 - x2);
        double dz = Math.abs(z1 - z2);
        return dx < 0.75 && dz < 0.75;
    }

    record LeftRightPair(Direction leftDirection, Direction rightDirection) {
    }
}

