/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client;

import com.equestricraft.common.Argb;
import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.core.plot.map.natural.PlotNaturalMapItem;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;

public class PlotMinimap {
    private static final Argb COLOR_BORDER = Argb.ARGB_BLACK;
    private static final Argb COLOR_BACKGROUND = Argb.ARGB_GREEN;
    private static final Argb COLOR_CROSS_HAIR = Argb.ARGB_RED;
    private static final Argb COLOR_PLOT_OWNED = Argb.ARGB_BLUE;
    private static final Argb COLOR_PLOT_ACCESS = Argb.ARGB_YELLOW;
    private static final Argb COLOR_PLOT_NO_ACCESS = Argb.ARGB_MC_GRAY;
    private static final int SIZE_CROSS_HAIR = 2;
    private static final PlotMinimap instance = new PlotMinimap();
    private List<PlotNaturalMapItem> plotsToShow = new ArrayList<PlotNaturalMapItem>(0);

    public static PlotMinimap getInstance() {
        return instance;
    }

    private PlotMinimap() {
    }

    public void setPlotsToShow(List<PlotNaturalMapItem> plotsToShow) {
        this.plotsToShow = plotsToShow;
    }

    protected void renderMap(Window window, PoseStack poseStack) {
        if (this.plotsToShow == null) {
            return;
        }
        int startingX = window.m_85445_() - 82;
        GuiUtil.drawSquare(poseStack, startingX, 0, 82, 82, 1, COLOR_BORDER);
        GuiUtil.drawFilledSquare(poseStack, startingX + 1, 1, 80, 80, COLOR_BACKGROUND);
        for (PlotNaturalMapItem item : this.plotsToShow) {
            Argb color = this.determineColor(item);
            for (Area2D area : item.areas()) {
                GuiUtil.drawFilledSquare(poseStack, Math.max(area.x1(), 0) + startingX + 1, Math.max(area.z1(), 0) + 1, Math.min(area.width(), 80), Math.min(area.height(), 80), color);
            }
        }
        int centerX = startingX + 41;
        int centerY = 41;
        GuiUtil.drawHorizontalLine(poseStack, centerX - 2, centerX + 2 + 1, centerY, 1, COLOR_CROSS_HAIR);
        GuiUtil.drawVerticalLine(poseStack, centerX, centerY - 2, centerY + 2 + 1, 1, COLOR_CROSS_HAIR);
    }

    private Argb determineColor(PlotNaturalMapItem item) {
        if (item.ownedByViewer()) {
            return COLOR_PLOT_OWNED;
        }
        if (item.accessibleByViewer()) {
            return COLOR_PLOT_ACCESS;
        }
        return COLOR_PLOT_NO_ACCESS;
    }
}

