/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ScreenFade {
    private static ScreenFadeSettings settings = null;

    public static void setScreenFade(long fadeInMillis, long stayMillis, long fadeOutMillis, Argb color) {
        long fadeInStartTime = System.currentTimeMillis();
        long fadeInEndTime = fadeInStartTime + fadeInMillis;
        long fadeOutStartTime = fadeInEndTime + stayMillis;
        long fadeOutEndTime = fadeOutStartTime + fadeOutMillis;
        settings = new ScreenFadeSettings(fadeInStartTime, fadeInEndTime, fadeOutStartTime, fadeOutEndTime, color);
    }

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent event) {
        ScreenFadeSettings current = settings;
        if (current != null && current.isValid()) {
            int transparencyValue = ScreenFade.calculateTransparencyValue(current);
            GuiUtil.drawFilledSquare(event.getMatrixStack(), 0, 0, event.getWindow().m_85445_(), event.getWindow().m_85446_(), current.color().withTransparency(transparencyValue));
        }
    }

    private static int calculateTransparencyValue(ScreenFadeSettings current) {
        long timeNow = System.currentTimeMillis();
        if (timeNow < current.fadeInEndTime()) {
            long timeSinceFadeInStart = timeNow - current.fadeInStartTime();
            float percentageThrough = (float)((double)timeSinceFadeInStart / (double)current.fadeInDuration());
            return (int)(255.0f * percentageThrough);
        }
        if (timeNow < current.fadeOutStartTime()) {
            return 255;
        }
        if (timeNow < current.fadeOutEndTime()) {
            long timeSinceFadeOutStart = timeNow - current.fadeOutStartTime();
            float percentageThrough = (float)((double)(current.fadeOutDuration() - timeSinceFadeOutStart) / (double)current.fadeOutDuration());
            return (int)(255.0f * percentageThrough);
        }
        return 0;
    }

    private record ScreenFadeSettings(long fadeInStartTime, long fadeInEndTime, long fadeOutStartTime, long fadeOutEndTime, Argb color) {
        long fadeInDuration() {
            return this.fadeInEndTime - this.fadeInStartTime;
        }

        long fadeOutDuration() {
            return this.fadeOutEndTime - this.fadeOutStartTime;
        }

        boolean isValid() {
            return System.currentTimeMillis() <= this.fadeOutEndTime;
        }
    }
}

