/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.bucket;

import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.mod.provision.ProvisionContainer;
import com.equestricraft.mod.provision.ProvisionContainerContentType;
import com.equestricraft.mod.provision.ProvisionContainerInteractEvent;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EntityBucket
extends Mob
implements ProvisionContainer<EntityBucket> {
    private static final EntityDataAccessor<String> contentType = SynchedEntityData.m_135353_(EntityBucket.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> quantity = SynchedEntityData.m_135353_(EntityBucket.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final String TAG_CONTENT_TYPE = "content_type";
    private static final String TAG_QUANTITY = "quantity";
    private static final String TAG_INFO = "info";
    private ProvisionContainerInfo provisionInfo = null;

    public EntityBucket(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, 2.0).m_22266_(Attributes.f_22288_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(contentType, (Object)ProvisionContainerContentType.FEED.name());
        this.f_19804_.m_135372_(quantity, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128359_(TAG_CONTENT_TYPE, this.getContentType().name());
        tag.m_128350_(TAG_QUANTITY, this.getQuantity());
        tag.m_128365_(TAG_INFO, (Tag)this.gatTagForInfo());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_(TAG_CONTENT_TYPE)) {
            this.setContentType(ProvisionContainerContentType.valueOf(tag.m_128461_(TAG_CONTENT_TYPE)));
        }
        if (tag.m_128441_(TAG_QUANTITY)) {
            this.setQuantity(tag.m_128457_(TAG_QUANTITY));
        }
        if (tag.m_128441_(TAG_INFO)) {
            this.setProvisionInfo(this.getInfoFromTag(tag.m_128469_(TAG_INFO)));
        }
    }

    @Override
    public ProvisionContainerInfo getProvisionInfo() {
        return this.provisionInfo;
    }

    @Override
    public void setProvisionInfo(ProvisionContainerInfo provisionInfo) {
        this.provisionInfo = provisionInfo;
    }

    @Override
    public ProvisionContainerContentType getContentType() {
        String type = (String)this.f_19804_.m_135370_(contentType);
        return ProvisionContainerContentType.valueOf(type);
    }

    @Override
    public void setContentType(ProvisionContainerContentType value) {
        this.f_19804_.m_135381_(contentType, (Object)value.name());
    }

    @Override
    public float getQuantity() {
        return ((Float)this.f_19804_.m_135370_(quantity)).floatValue();
    }

    @Override
    public void setQuantity(float value) {
        this.f_19804_.m_135381_(quantity, (Object)Float.valueOf(value));
    }

    @Override
    public Vec3 getPosition() {
        return this.m_20182_();
    }

    @Override
    public EntityBucket asEntity() {
        return this;
    }

    public boolean m_5807_() {
        return this.m_6688_() instanceof LivingEntity;
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity pushingEntity) {
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_) {
            ProvisionContainerInteractEvent event = new ProvisionContainerInteractEvent(this, (ServerPlayer)player);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_142391_() {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

