/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.bulletin.BulletinInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBulletinClosedPacket;
import com.equestricraft.mod.packet.ServerBoundBulletinNextPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class BulletinScreen
extends Screen {
    private final BulletinInfo bulletin;
    private ECMultiLineField messageField = null;

    public static void showScreen(BulletinInfo bulletin) {
        BulletinScreen screen = new BulletinScreen(bulletin);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private BulletinScreen(BulletinInfo bulletin) {
        super((Component)ComponentUtil.buildColoredTextComponent(bulletin.title()));
        this.bulletin = bulletin;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECButton closeButton = ECButton.Builder.start(10, 10, 80, 20).withLabel(I18n.getLabel("common.close")).withOnClick(this::closeBulletin).complete();
        this.m_142416_((GuiEventListener)closeButton);
        ECButton nextButton = ECButton.Builder.start(this.f_96543_ - 10, 10, 80, 20).withLabel(I18n.getLabel("bulletin.menu.next")).withOnClick(this::nextBulletin).rightAligned().complete();
        this.m_142416_((GuiEventListener)nextButton);
        this.messageField = ECMultiLineField.Builder.start().withPosition(10, 45).withWidth(this.f_96543_ - 20).withLabel(this.bulletin.text()).complete();
    }

    private void closeBulletin() {
        this.m_7379_();
        ServerBoundBulletinClosedPacket packet = new ServerBoundBulletinClosedPacket(this.bulletin.id());
        Network.sendToServer(packet);
    }

    private void nextBulletin() {
        this.m_7379_();
        ServerBoundBulletinNextPacket packet = new ServerBoundBulletinNextPacket(this.bulletin.id());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        BulletinScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.messageField.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

