/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.RGBSlider;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class ColorPicker
extends ECWidget {
    private final RGBSlider redSlider;
    private final RGBSlider greenSlider;
    private final RGBSlider blueSlider;
    private final int colorBoxWidth;
    private final ECTextField hexField;

    public ColorPicker(int x, int y, int width) {
        super(x, y, width, 60);
        this.colorBoxWidth = width / 5;
        this.redSlider = new RGBSlider(this.dx(0), this.dy(0), width - this.colorBoxWidth, 255.0, RGBSlider.Channel.RED);
        this.greenSlider = new RGBSlider(this.dx(0), this.dy(20), width - this.colorBoxWidth, 255.0, RGBSlider.Channel.GREEN);
        this.blueSlider = new RGBSlider(this.dx(0), this.dy(40), width - this.colorBoxWidth, 255.0, RGBSlider.Channel.BLUE);
        this.hexField = ECTextField.Builder.start(this.dx(width - this.colorBoxWidth), this.dy(40), this.colorBoxWidth).withDefaultValue(this.getColor().getHexValue()).withOnUpdate(this::updateColorsFromHexInput).complete();
    }

    private void updateColorsFromHexInput(String hex) {
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        try {
            Argb color = Argb.fromHexString((String)hex);
            this.redSlider.setValue(color.red());
            this.greenSlider.setValue(color.green());
            this.blueSlider.setValue(color.blue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean onClick(double mouseX, double mouseY, int action) {
        if (this.hexField.m_5953_(mouseX, mouseY)) {
            this.hexField.m_93692_(true);
            return true;
        }
        this.hexField.m_93692_(false);
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.redSlider.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.greenSlider.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.blueSlider.m_6305_(poseStack, mouseX, mouseY, partialTick);
        GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - this.colorBoxWidth), this.dy(0), this.colorBoxWidth, 40, this.getColor());
        this.hexField.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyPressed, int val2, int shift) {
        return this.hexField.m_7933_(keyPressed, val2, shift);
    }

    public boolean m_5534_(char typed, int shift) {
        return this.hexField.m_5534_(typed, shift);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.redSlider.m_5953_(mouseX, mouseY)) {
            this.redSlider.m_7212_(mouseX, mouseY, deltaX, deltaY);
        }
        if (this.greenSlider.m_5953_(mouseX, mouseY)) {
            this.greenSlider.m_7212_(mouseX, mouseY, deltaX, deltaY);
        }
        if (this.blueSlider.m_5953_(mouseX, mouseY)) {
            this.blueSlider.m_7212_(mouseX, mouseY, deltaX, deltaY);
        }
        Argb color = this.getColor();
        this.hexField.setValue(color.getHexValue());
    }

    public Argb getColor() {
        int redValue = this.redSlider.getValue();
        int greenValue = this.greenSlider.getValue();
        int blueValue = this.blueSlider.getValue();
        return new Argb(255, redValue, greenValue, blueValue);
    }
}

