/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.fasttravel.FastTravelGroupInfo;
import com.equestricraft.core.fasttravel.FastTravelPointInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundFastTravelPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FastTravelMenuScreen
extends Screen {
    private final FastTravelGroupInfo currentGroup;
    private final FastTravelPointInfo currentPoint;
    private final List<FastTravelPointInfo> points;
    private String stopLabel = "";
    private String costLabel = "";

    public static void showScreen(FastTravelGroupInfo currentGroup, FastTravelPointInfo currentPoint, List<FastTravelPointInfo> points) {
        FastTravelMenuScreen screen = new FastTravelMenuScreen(currentGroup, currentPoint, points);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected FastTravelMenuScreen(FastTravelGroupInfo currentGroup, FastTravelPointInfo currentPoint, List<FastTravelPointInfo> points) {
        super((Component)ComponentUtil.buildColoredTextComponent(currentGroup.groupName()));
        this.currentGroup = currentGroup;
        this.currentPoint = currentPoint;
        this.points = points;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.stopLabel = this.currentPoint.pointName();
        this.costLabel = I18n.getLabel("fast-travel.menu.cost", this.currentGroup.groupCostString());
        int x = 20;
        int y = 65;
        for (FastTravelPointInfo point : this.points) {
            int width = this.f_96547_.m_92895_(point.pointName()) + 10;
            if (x > this.f_96543_ - (width + 5)) {
                x = 20;
                y += 25;
            }
            ECButton button = ECButton.Builder.start(x, y, width, 20).withLabel(point.pointName()).withOnClick(() -> this.onPointClick(point)).complete();
            x += width + 5;
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void onPointClick(FastTravelPointInfo point) {
        ServerBoundFastTravelPacket packet = new ServerBoundFastTravelPacket(point.pointId());
        Network.sendToServer(packet);
        super.m_7379_();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        FastTravelMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        FastTravelMenuScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.stopLabel, (int)(this.f_96543_ / 2), (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        FastTravelMenuScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.costLabel, (int)(this.f_96543_ / 2), (int)50, (int)GuiConstants.COLOR_WHITE);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

