/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.FeedbackType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECCheckboxGroup;
import com.equestricraft.mod.client.gui.components.ECTextBox;
import com.equestricraft.mod.client.gui.components.ECTextField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundFeedbackSubmitPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class FeedbackSubmitScreen
extends Screen {
    private final String message;
    private final ECCheckboxGroup<FeedbackType> typeCheckboxGroup = new ECCheckboxGroup();

    public static void showScreen(String message) {
        FeedbackSubmitScreen screen = new FeedbackSubmitScreen(message);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private FeedbackSubmitScreen(String message) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("feedback.menu.title")));
        this.message = Objects.requireNonNullElse(message, "");
    }

    protected void m_7856_() {
        super.m_7856_();
        ECTextField titleField = ECTextField.Builder.start(10, 25, this.f_96543_ - 20).withLabel(I18n.getLabel("feedback.menu.field.title.label")).complete();
        this.m_142416_((GuiEventListener)titleField);
        ECTextBox messageField = ECTextBox.Builder.start(10, 45, this.f_96543_ - 20, 50).withLabel(I18n.getLabel("feedback.menu.field.message.label")).withDefaultText(this.message).complete();
        this.m_142416_((GuiEventListener)messageField);
        ECCheckbox<FeedbackType> suggestionCheckbox = ECCheckbox.Builder.start(10, 105).withText(I18n.getLabel("feedback.menu.checkbox.suggestion.label")).withOptionValue(FeedbackType.SUGGESTION).withGroup(this.typeCheckboxGroup).complete();
        this.m_142416_((GuiEventListener)suggestionCheckbox);
        ECCheckbox<FeedbackType> complaintCheckbox = ECCheckbox.Builder.start(this.f_96543_ / 2 + 10, 105).withText(I18n.getLabel("feedback.menu.checkbox.complaint.label")).withOptionValue(FeedbackType.COMPLAINT).withGroup(this.typeCheckboxGroup).complete();
        this.m_142416_((GuiEventListener)complaintCheckbox);
        ECButton submitButton = ECButton.Builder.start(this.f_96543_ - 90, this.f_96544_ - 30, 80, 20).withLabel(I18n.getLabel("feedback.menu.button.submit.label")).withOnClick(() -> {
            String title = titleField.getValue();
            String enteredMessage = messageField.getValue();
            Optional<FeedbackType> type = this.typeCheckboxGroup.getSelected();
            if (type.isPresent()) {
                ServerBoundFeedbackSubmitPacket packet = new ServerBoundFeedbackSubmitPacket(title, enteredMessage, type.get());
                Network.sendToServer(packet);
                this.m_7379_();
            }
        }).complete();
        this.m_142416_((GuiEventListener)submitButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

