/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.client.NativeImageConverter;
import com.equestricraft.mod.client.gui.components.ScreenText;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class GuiUtil {
    public static void drawFilledSquare(PoseStack poseStack, int x, int y, int width, int height, Argb color) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color.getIntValue());
    }

    public static void drawSquare(PoseStack poseStack, int x, int y, int width, int height, int borderWidth, Argb color) {
        GuiUtil.drawHorizontalLine(poseStack, x, x + width, y, borderWidth, color);
        GuiUtil.drawHorizontalLine(poseStack, x, x + width, y + height - borderWidth, borderWidth, color);
        GuiUtil.drawVerticalLine(poseStack, x, y, y + height, borderWidth, color);
        GuiUtil.drawVerticalLine(poseStack, x + width - borderWidth, y, y + height, borderWidth, color);
    }

    public static void drawHorizontalLine(PoseStack poseStack, int x1, int x2, int y, int thickness, Argb color) {
        GuiUtil.drawFilledSquare(poseStack, x1, y, x2 - x1, thickness, color);
    }

    public static void drawVerticalLine(PoseStack poseStack, int x, int y1, int y2, int thickness, Argb color) {
        GuiUtil.drawFilledSquare(poseStack, x, y1, thickness, y2 - y1, color);
    }

    public static void drawImage(PoseStack poseStack, String resourcePath, int x, int y, int width, int height) {
        ResourceLocation resourceLocation = new ResourceLocation("equestricraft", resourcePath);
        GuiUtil.drawImage(poseStack, resourceLocation, x, y, width, height);
    }

    public static void drawImage(PoseStack poseStack, ResourceLocation resourceLocation, int x, int y, int width, int height) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.m_69482_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public static void drawImage(PoseStack poseStack, BufferedImage bufferedImage, int x, int y, int width, int height) {
        NativeImage nativeImage = NativeImageConverter.createNativeImage(bufferedImage);
        GuiUtil.drawImage(poseStack, nativeImage, x, y, width, height);
    }

    public static void drawImage(PoseStack poseStack, NativeImage nativeImage, int x, int y, int width, int height) {
        DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
        ResourceLocation resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_(UUID.randomUUID().toString(), dynamicTexture);
        GuiUtil.drawImage(poseStack, resourceLocation, x, y, width, height);
    }

    public static void drawString(PoseStack poseStack, Component component, int x, int y, Argb color) {
        GuiComponent.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)component, (int)x, (int)y, (int)color.getIntValue());
    }

    public static void drawString(PoseStack poseStack, String string, int x, int y, Argb color) {
        GuiComponent.m_93236_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)string, (int)x, (int)y, (int)color.getIntValue());
    }

    public static void drawCenteredString(PoseStack poseStack, Component component, int x, int y, Argb color) {
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)component, (int)x, (int)y, (int)color.getIntValue());
    }

    public static void drawCenteredString(PoseStack poseStack, String string, int x, int y, Argb color) {
        GuiComponent.m_93208_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)string, (int)x, (int)y, (int)color.getIntValue());
    }

    public static int getStandardLineHeight() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9;
    }

    public static int getSpacedLineHeight() {
        return GuiUtil.getStandardLineHeight() + 2;
    }

    public static int getStandardTextWidth(String text) {
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public static int getStandardTextWidth(Component component) {
        return Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
    }

    public static void renderWithScale(PoseStack poseStack, int width, int height, double scale, AbstractWidget abstractWidget, int mouseX, int mouseY, float partialTick) {
        GuiUtil.renderWithScaleImpl(poseStack, width, height, scale, abstractWidget, mouseX, mouseY, partialTick);
    }

    public static void renderWithScale(PoseStack poseStack, int width, int height, double scale, ScreenText screenText, int mouseX, int mouseY, float partialTick) {
        GuiUtil.renderWithScaleImpl(poseStack, width, height, scale, screenText, mouseX, mouseY, partialTick);
    }

    private static void renderWithScaleImpl(PoseStack poseStack, int width, int height, double scale, Object object, int mouseX, int mouseY, float partialTick) {
        poseStack.m_85837_((double)(-width) / 2.0, (double)(-height) / 2.0, 0.0);
        poseStack.m_85841_((float)scale, (float)scale, 1.0f);
        poseStack.m_85837_((double)width / 2.0 / scale, (double)height / 2.0 / scale, 0.0);
        if (object instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)object;
            int x0 = widget.f_93620_;
            int y0 = widget.f_93621_;
            widget.f_93620_ = (int)((double)widget.f_93620_ / scale);
            widget.f_93621_ = (int)((double)widget.f_93621_ / scale);
            widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
            widget.f_93620_ = x0;
            widget.f_93621_ = y0;
        } else if (object instanceof ScreenText) {
            ScreenText text = (ScreenText)object;
            GuiComponent.m_93236_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)text.text(), (int)text.x(), (int)text.y(), (int)text.color());
        } else {
            throw new IllegalArgumentException("Supplied non-renderable object!");
        }
        poseStack.m_85837_((double)(-width) / 2.0 / scale, (double)(-height) / 2.0 / scale, 0.0);
        poseStack.m_85841_((float)(1.0 / scale), (float)(1.0 / scale), 1.0f);
        poseStack.m_85837_((double)width / 2.0, (double)height / 2.0, 0.0);
    }

    private GuiUtil() {
    }
}

