/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LoadingScreen
extends Screen {
    private final long openTime = System.currentTimeMillis();

    public static void showLoadingScreen() {
        LoadingScreen.showLoadingScreen(null);
    }

    public static void showLoadingScreen(String text) {
        LoadingScreen screen = new LoadingScreen(text != null ? text : I18n.getLabel("loading.label"));
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private LoadingScreen(String text) {
        super((Component)ComponentUtil.buildColoredTextComponent(text));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        LoadingScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 25), (int)GuiConstants.COLOR_WHITE);
        this.drawLoadingBar(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void drawLoadingBar(PoseStack poseStack) {
        GuiUtil.drawFilledSquare(poseStack, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 5, 200, 3, Argb.ARGB_MC_AQUA.withTransparency(50));
        long millisSinceOpen = System.currentTimeMillis() - this.openTime;
        float progress = (float)(millisSinceOpen % 1000L) / 1000.0f;
        int barWidth = (int)(progress * 200.0f);
        GuiUtil.drawFilledSquare(poseStack, this.f_96543_ / 2 - 100, this.f_96544_ / 2 - 5, barWidth, 3, Argb.ARGB_MC_AQUA);
    }
}

