/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.season.SeasonType;
import com.equestricraft.core.global.GlobalContextInfo;
import com.equestricraft.core.horse.list.HorseListSortOrder;
import com.equestricraft.core.player.PlayerContextInfo;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.URLOpener;
import com.equestricraft.mod.client.gui.FeedbackSubmitScreen;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECAlignment;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundHorseListRefreshPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerAchievementMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerNotificationMenuOpenRequestPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerProgressionMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundPlayerSettingsMenuOpenPacket;
import com.equestricraft.mod.packet.ServerBoundShowProfileMenuPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MainMenuScreen
extends Screen {
    private final ResourceLocation horseIcon = Resources.getTextures().getGui().get("horse_icon.png");
    private final ResourceLocation settingIcon = Resources.getTextures().getGui().get("setting_icon.png");
    private final ResourceLocation bellIcon = Resources.getTextures().getGui().get("bell.png");
    private final ResourceLocation profileIcon = Resources.getTextures().getGui().get("profile_icon.png");
    private final ResourceLocation progressionIcon = Resources.getTextures().getGui().get("progression.png");
    private final ResourceLocation achievementIcon = Resources.getTextures().getGui().get("achievement.png");
    private final GlobalContextInfo globalContextInfo;
    private final PlayerContextInfo playerContextInfo;
    private final String supportUrl;
    private final String discordUrl;
    private final String wikiUrl;

    public static void showScreen(GlobalContextInfo globalContextInfo, PlayerContextInfo playerContextInfo, String supportUrl, String discordUrl, String wikiUrl) {
        MainMenuScreen screen = new MainMenuScreen(globalContextInfo, playerContextInfo, supportUrl, discordUrl, wikiUrl);
        ScreenStack.getInstance().push(screen);
    }

    private MainMenuScreen(GlobalContextInfo globalContextInfo, PlayerContextInfo playerContextInfo, String supportUrl, String discordUrl, String wikiUrl) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("main-menu.title")));
        this.globalContextInfo = globalContextInfo;
        this.playerContextInfo = playerContextInfo;
        this.supportUrl = supportUrl;
        this.discordUrl = discordUrl;
        this.wikiUrl = wikiUrl;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initGlobalContext();
        this.initPlayerContext();
        this.initButtons();
    }

    private void initGlobalContext() {
        int currentY = 20;
        ECField currentSeasonField = ECField.Builder.start(10, currentY, 100).withValue(this.globalContextInfo.currentSeason().getTranslatedName()).withValueColor(this.getColor(this.globalContextInfo.currentSeason())).complete();
        this.m_142416_((GuiEventListener)currentSeasonField);
        ECField temperatureField = ECField.Builder.start(10, currentY += currentSeasonField.m_93694_(), 100).withValue(this.globalContextInfo.currentWeather().temperatureFormatted()).complete();
        this.m_142416_((GuiEventListener)temperatureField);
        ECField windSpeedField = ECField.Builder.start(10, currentY += temperatureField.m_93694_(), 100).withValue(this.globalContextInfo.currentWeather().windSpeedFormatted()).complete();
        this.m_142416_((GuiEventListener)windSpeedField);
        ECField weatherTypeFormatted = ECField.Builder.start(10, currentY += windSpeedField.m_93694_(), 100).withValue(this.globalContextInfo.currentWeather().weatherType().getTranslatedName()).withValueColor(this.getColor(this.globalContextInfo.currentWeather().weatherType())).complete();
        this.m_142416_((GuiEventListener)weatherTypeFormatted);
    }

    private void initPlayerContext() {
        int currentY = 20;
        ECField displayNameField = ECField.Builder.start(this.f_96543_ - 10, currentY, 100).withValue(this.playerContextInfo.displayName()).rightAligned().complete();
        this.m_142416_((GuiEventListener)displayNameField);
        currentY += displayNameField.m_93694_();
        if (this.playerContextInfo.selectedHorseName() != null) {
            ECField selectedHorseField = ECField.Builder.start(this.f_96543_ - 10, currentY, 100).withLabel(I18n.getLabel("main-menu.selected-horse.field.label")).withValue(this.playerContextInfo.selectedHorseName()).rightAligned().complete();
            this.m_142416_((GuiEventListener)selectedHorseField);
            currentY += selectedHorseField.m_93694_();
        }
        ECField balanceField = ECField.Builder.start(this.f_96543_ - 10, currentY, 100).withValue(this.playerContextInfo.balance()).rightAligned().complete();
        this.m_142416_((GuiEventListener)balanceField);
        ECField rankField = ECField.Builder.start(this.f_96543_ - 10, currentY += balanceField.m_93694_(), 100).withValue(this.playerContextInfo.rank()).rightAligned().complete();
        this.m_142416_((GuiEventListener)rankField);
        ECField xpField = ECField.Builder.start(this.f_96543_ - 10, currentY += rankField.m_93694_(), 100).withValue(I18n.getLabel("main-menu.xp.field.value", this.playerContextInfo.xp())).rightAligned().complete();
        this.m_142416_((GuiEventListener)xpField);
        currentY += xpField.m_93694_();
        if (this.playerContextInfo.clubName() != null) {
            ECField clubField = ECField.Builder.start(this.f_96543_ - 10, currentY, 100).withValue(this.playerContextInfo.clubName()).rightAligned().complete();
            this.m_142416_((GuiEventListener)clubField);
        }
    }

    private Argb getColor(SeasonType seasonType) {
        return switch (seasonType) {
            default -> throw new IncompatibleClassChangeError();
            case SeasonType.SPRING -> Argb.ARGB_GREEN;
            case SeasonType.SUMMER -> Argb.ARGB_YELLOW;
            case SeasonType.AUTUMN -> Argb.ARGB_RED;
            case SeasonType.WINTER -> Argb.ARGB_BLUE;
        };
    }

    private Argb getColor(WeatherType weatherType) {
        return switch (weatherType) {
            default -> throw new IncompatibleClassChangeError();
            case WeatherType.CLEAR -> Argb.ARGB_WHITE;
            case WeatherType.CLOUD -> Argb.ARGB_MC_GRAY;
            case WeatherType.RAIN -> Argb.ARGB_BLUE;
        };
    }

    private void initButtons() {
        int center = this.f_96543_ / 2;
        int buttonWidth = 120;
        int buttonHeight = 20;
        int buttonGap = 5;
        int spacing = 25;
        int currentY = 40;
        ECButton horseListButton = ECButton.Builder.start(center, currentY, 120, 20).withLabel(I18n.getLabel("main-menu.horse-list.button.label")).withIcon(this.horseIcon, 20, 20).withOnClick(() -> {
            ServerBoundHorseListRefreshPacket packet = new ServerBoundHorseListRefreshPacket(1, HorseListSortOrder.NATURAL, SortDirection.ASCENDING, "");
            Network.sendToServer(packet);
        }).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)horseListButton);
        ECButton progressionButton = ECButton.Builder.start(center, currentY += 25, 120, 20).withLabel(I18n.getLabel("main-menu.progression.button.label")).withIcon(this.progressionIcon, 20, 20).withOnClick(() -> Network.sendToServer(new ServerBoundPlayerProgressionMenuOpenPacket())).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)progressionButton);
        ECButton achievementsButton = ECButton.Builder.start(center, currentY += 25, 120, 20).withLabel(I18n.getLabel("main-menu.achievements.button.label")).withIcon(this.achievementIcon, 20, 20).withOnClick(() -> Network.sendToServer(new ServerBoundPlayerAchievementMenuOpenPacket())).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)achievementsButton);
        ECButton myProfileButton = ECButton.Builder.start(center, currentY += 25, 120, 20).withLabel(I18n.getLabel("main-menu.my-profile.button.label")).withIcon(this.profileIcon, 20, 20).withOnClick(() -> Network.sendToServer(new ServerBoundShowProfileMenuPacket())).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)myProfileButton);
        ECButton myNotificationsButton = ECButton.Builder.start(center, currentY += 25, 120, 20).withLabel(I18n.getLabel("main-menu.my-notifications.button.label")).withIcon(this.bellIcon, 20, 20).withOnClick(() -> {
            ServerBoundPlayerNotificationMenuOpenRequestPacket packet = new ServerBoundPlayerNotificationMenuOpenRequestPacket(1, SortDirection.ASCENDING, "");
            Network.sendToServer(packet);
        }).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)myNotificationsButton);
        ECButton mySettingsButton = ECButton.Builder.start(center, currentY += 25, 120, 20).withLabel(I18n.getLabel("main-menu.my-settings.button.label")).withIcon(this.settingIcon, 20, 20).withOnClick(() -> Network.sendToServer(new ServerBoundPlayerSettingsMenuOpenPacket())).withAlignment(ECAlignment.CENTER).complete();
        this.m_142416_((GuiEventListener)mySettingsButton);
        ECButton supportButton = ECButton.Builder.start(10, this.f_96544_ - 30, 100, 20).withLabel(I18n.getLabel("main-menu.report-issue.button.label")).withOnClick(this::onSupportClick).complete();
        this.m_142416_((GuiEventListener)supportButton);
        ECButton discordButton = ECButton.Builder.start(115, this.f_96544_ - 30, 100, 20).withLabel(I18n.getLabel("main-menu.discord.button.label")).withOnClick(this::onDiscordClick).complete();
        this.m_142416_((GuiEventListener)discordButton);
        ECButton wikiButton = ECButton.Builder.start(220, this.f_96544_ - 30, 100, 20).withLabel(I18n.getLabel("main-menu.wiki.button.label")).withOnClick(this::onWikiClick).complete();
        this.m_142416_((GuiEventListener)wikiButton);
        ECButton feedbackButton = ECButton.Builder.start(325, this.f_96544_ - 30, 100, 20).withLabel(I18n.getLabel("main-menu.feedback.button.label")).withOnClick(this::onFeedbackClick).complete();
        this.m_142416_((GuiEventListener)feedbackButton);
    }

    private void onSupportClick() {
        URLOpener.openUrl(this.supportUrl);
    }

    private void onDiscordClick() {
        URLOpener.openUrl(this.discordUrl);
    }

    private void onWikiClick() {
        URLOpener.openUrl(this.wikiUrl);
    }

    private void onFeedbackClick() {
        FeedbackSubmitScreen.showScreen("");
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        MainMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

