/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.npc.NpcActionInfo;
import com.equestricraft.mod.packet.ServerBoundNPCActionSelectPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class NPCActionMenuScreen
extends Screen {
    private final List<NpcActionInfo> actions;

    public static void showScreen(String title, List<NpcActionInfo> actions) {
        NPCActionMenuScreen screen = new NPCActionMenuScreen(title, actions);
        ScreenStack.getInstance().push(screen);
    }

    NPCActionMenuScreen(String title, List<NpcActionInfo> actions) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.actions = actions;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.renderList();
    }

    private void renderList() {
        int y = 35;
        for (NpcActionInfo action : this.actions) {
            int buttonWidth = this.f_96547_.m_92895_(action.label()) + 10;
            ECButton button = ECButton.Builder.start(this.f_96543_ / 2, y, buttonWidth, 20).withLabel(action.label()).withOnClick(() -> this.onItemClick(action)).centerAligned().complete();
            y += 25;
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void onItemClick(NpcActionInfo action) {
        ServerBoundNPCActionSelectPacket packet = new ServerBoundNPCActionSelectPacket(action.identifier());
        Network.sendToServer(packet);
    }

    public void m_6305_(PoseStack poseStack, int val1, int val2, float val3) {
        this.m_7333_(poseStack);
        NPCActionMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, val1, val2, val3);
    }
}

