/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.base.pagination.Page;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class PageScreen<P extends Page<T, S, F>, T, S, F>
extends Screen {
    protected final P page;
    private String pageNumberLabel = "";

    protected PageScreen(String title, P page) {
        super((Component)ComponentUtil.buildColoredTextComponent(title));
        this.page = page;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.pageNumberLabel = I18n.getLabel("pagination.pages.label", ((Page)this.page).getPageNumber(), ((Page)this.page).getTotalPages());
        if (((Page)this.page).getPageNumber() > 1) {
            ECButton previousPageButton = ECButton.Builder.start(5, this.f_96544_ - 25, 30, 20).withLabel(I18n.getLabel("pagination.button.previous-page.label")).withOnClick(() -> this.onChangePage(((Page)this.page).getPageNumber() - 1)).complete();
            this.m_142416_((GuiEventListener)previousPageButton);
        }
        if (((Page)this.page).getPageNumber() < ((Page)this.page).getTotalPages()) {
            ECButton nextPageButton = ECButton.Builder.start(this.f_96543_ - 5, this.f_96544_ - 25, 30, 20).withLabel(I18n.getLabel("pagination.button.next-page.label")).withOnClick(() -> this.onChangePage(((Page)this.page).getPageNumber() + 1)).rightAligned().complete();
            this.m_142416_((GuiEventListener)nextPageButton);
        }
    }

    public abstract void onChangePage(int var1);

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        PageScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.pageNumberLabel, (int)(this.f_96543_ / 2), (int)(this.f_96544_ - 15), (int)GuiConstants.COLOR_WHITE);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

