/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.player.achievement.PlayerAchievementInfo;
import com.mojang.blaze3d.vertex.PoseStack;

public class PlayerAchievementWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField completedField;
    private final ECProgressBar progressBar;
    private final ECField xpRewardField;
    private final ECMultiLineField descriptionField;

    protected PlayerAchievementWidget(int x, int y, int width, PlayerAchievementInfo playerAchievementInfo) {
        super(x, y, width, 0);
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(playerAchievementInfo.name()).complete();
        if (playerAchievementInfo.completed()) {
            this.completedField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(I18n.getLabel("player.achievement.menu.field.completed.label")).withValueColor(Argb.ARGB_GREEN).rightAligned().complete();
            this.progressBar = null;
        } else {
            this.completedField = null;
            this.progressBar = ECProgressBar.Builder.start(this.dx(width), this.dy(0), 100).withValue((int)playerAchievementInfo.percentageCompletion()).withFilledColor(Argb.ARGB_MC_AQUA).rightAligned().complete();
        }
        int currentY = GuiUtil.getStandardLineHeight();
        if (playerAchievementInfo.xpReward() > 0) {
            this.xpRewardField = ECField.Builder.start(this.dx(0), this.dy(currentY), width).withValue(I18n.getLabel("player.achievement.menu.field.xp.label", playerAchievementInfo.xpReward())).withValueColor(Argb.ARGB_YELLOW).complete();
            currentY += GuiUtil.getStandardLineHeight();
        } else {
            this.xpRewardField = null;
        }
        this.descriptionField = ECMultiLineField.Builder.start().withLabel(playerAchievementInfo.description()).withPosition(this.dx(0), this.dy(currentY)).withWidth(width).complete();
        this.setHeight(currentY + this.descriptionField.getHeight());
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.completedField != null) {
            this.completedField.f_93621_ = this.dy(0);
            this.completedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.progressBar != null) {
            this.progressBar.f_93621_ = this.dy(0);
            this.progressBar.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        int currentY = GuiUtil.getStandardLineHeight();
        if (this.xpRewardField != null) {
            this.xpRewardField.f_93621_ = this.dy(currentY);
            this.xpRewardField.m_6305_(poseStack, mouseX, mouseY, partialTick);
            currentY += GuiUtil.getStandardLineHeight();
        }
        this.descriptionField.position(this.dx(0), this.dy(currentY));
        this.descriptionField.render(poseStack);
    }
}

