/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.profile.PlayerProfileInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerProfileScreen
extends Screen {
    private final PlayerProfileInfo playerProfileInfo;

    public static void showScreen(PlayerProfileInfo playerProfileInfo) {
        PlayerProfileScreen screen = new PlayerProfileScreen(playerProfileInfo);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected PlayerProfileScreen(PlayerProfileInfo playerProfileInfo) {
        super((Component)ComponentUtil.buildColoredTextComponent(playerProfileInfo.player().ign()));
        this.playerProfileInfo = playerProfileInfo;
    }

    protected void m_7856_() {
        super.m_7856_();
        ECField onlineStatusField = ECField.Builder.start(this.f_96543_ - 10, 10, this.f_96543_ - 20).withLabel(this.playerProfileInfo.onlineNow() ? I18n.getLabel("player-profile.menu.online-now") : I18n.getLabel("player-profile.menu.offline")).rightAligned().complete();
        this.m_142416_((GuiEventListener)onlineStatusField);
        int x = 10;
        int y = 35;
        if (this.playerProfileInfo.player().hasNickname()) {
            ECField nicknameField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.nickname.label")).withValue(this.playerProfileInfo.player().nickname()).complete();
            this.m_142416_((GuiEventListener)nicknameField);
            y += GuiUtil.getStandardLineHeight();
        }
        ECField joinDateField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.join-date.label")).withValue(this.playerProfileInfo.joinDate()).complete();
        this.m_142416_((GuiEventListener)joinDateField);
        y += GuiUtil.getStandardLineHeight();
        if (this.playerProfileInfo.lastSeen() != null) {
            ECField lastSeenField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.last-seen.label")).withValue(this.playerProfileInfo.lastSeen()).complete();
            this.m_142416_((GuiEventListener)lastSeenField);
            y += GuiUtil.getStandardLineHeight();
        }
        ECField xpField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.xp.label")).withValue(this.playerProfileInfo.xp()).complete();
        this.m_142416_((GuiEventListener)xpField);
        ECField rankField = ECField.Builder.start(x, y += GuiUtil.getStandardLineHeight(), this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.rank.label")).withValue(this.playerProfileInfo.rank()).withValueColor(this.playerProfileInfo.rankColor()).complete();
        this.m_142416_((GuiEventListener)rankField);
        y += GuiUtil.getStandardLineHeight();
        if (this.playerProfileInfo.job() != null) {
            ECField jobField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.job.label")).withValue(this.playerProfileInfo.job()).complete();
            this.m_142416_((GuiEventListener)jobField);
            y += GuiUtil.getStandardLineHeight();
        }
        if (this.playerProfileInfo.universityHouse() != null) {
            ECField universityHouseField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.university-house.label")).withValue(this.playerProfileInfo.universityHouse()).complete();
            this.m_142416_((GuiEventListener)universityHouseField);
            y += GuiUtil.getStandardLineHeight();
        }
        if (this.playerProfileInfo.club() != null) {
            ECField clubField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.club.label")).withValue(this.playerProfileInfo.club()).complete();
            this.m_142416_((GuiEventListener)clubField);
            y += GuiUtil.getStandardLineHeight();
        }
        ECField houseCountField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.horse-count.label")).withValue(this.playerProfileInfo.horseCount()).complete();
        this.m_142416_((GuiEventListener)houseCountField);
        y += GuiUtil.getStandardLineHeight();
        if (this.playerProfileInfo.rideStylePreference() != null) {
            ECField rideStyleField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.ride-style.label")).withValue(this.playerProfileInfo.rideStylePreference().getTranslatedName()).complete();
            this.m_142416_((GuiEventListener)rideStyleField);
            y += GuiUtil.getStandardLineHeight();
        }
        if (this.playerProfileInfo.donatorLevel() != null) {
            ECField donatorLevelField = ECField.Builder.start(x, y, this.f_96543_ - 20).withLabel(I18n.getLabel("player-profile.menu.field.donator-level.label")).withValue(this.playerProfileInfo.donatorLevel().getTranslatedName()).complete();
            this.m_142416_((GuiEventListener)donatorLevelField);
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerProfileScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

