/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.progression.PlayerProgressionMilestoneInfo;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECProgressBar;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;

public class PlayerProgressionMilestoneWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField groupField;
    private final ECField unlockedField;
    private final ECProgressBar progressBar;

    protected PlayerProgressionMilestoneWidget(int x, int y, int width, int playerXp, PlayerProgressionMilestoneInfo playerProgressionMilestoneInfo) {
        super(x, y, width, 0);
        this.groupField = ECField.Builder.start(this.dx(0), this.dy(0), width).withValue(playerProgressionMilestoneInfo.group()).withValueColor(playerProgressionMilestoneInfo.unlocked() ? Argb.ARGB_GREEN : Argb.ARGB_MC_GRAY).complete();
        this.nameField = ECField.Builder.start(this.dx(90), this.dy(0), width).withValue(playerProgressionMilestoneInfo.name()).withValueColor(playerProgressionMilestoneInfo.unlocked() ? Argb.ARGB_GREEN : Argb.ARGB_MC_GRAY).complete();
        if (playerProgressionMilestoneInfo.unlocked()) {
            this.unlockedField = ECField.Builder.start(this.dx(width), this.dy(0), width).withValue(I18n.getLabel("player.progression.menu.item.unlocked.label")).withValueColor(Argb.ARGB_GREEN).rightAligned().complete();
            this.progressBar = null;
        } else {
            this.unlockedField = null;
            this.progressBar = ECProgressBar.Builder.start(this.dx(width), this.dy(0), 100).withValue((int)((double)playerXp / (double)playerProgressionMilestoneInfo.xpRequired() * 100.0)).rightAligned().complete();
        }
        this.setHeight(this.nameField.m_93694_());
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return false;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.f_93621_ = this.dy(0);
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.groupField.f_93621_ = this.dy(0);
        this.groupField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.unlockedField != null) {
            this.unlockedField.f_93621_ = this.dy(0);
            this.unlockedField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.progressBar != null) {
            this.progressBar.f_93621_ = this.dy(0);
            this.progressBar.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }
}

