/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.settings.PlayerSettingsDto;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECCheckbox;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPlayerSettingsUpdatePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class PlayerSettingsMenuScreen
extends Screen {
    private final PlayerSettingsDto playerSettingsDto;
    private ECMultiLineField questLabel = null;
    private ECCheckbox<Object> questCheckbox = null;
    private ECMultiLineField plotMinimapLabel = null;
    private ECCheckbox<Object> plotMinimapCheckbox = null;

    public static void showScreen(PlayerSettingsDto playerSettingsDto) {
        PlayerSettingsMenuScreen screen = new PlayerSettingsMenuScreen(playerSettingsDto);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected PlayerSettingsMenuScreen(PlayerSettingsDto playerSettingsDto) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("player-settings.menu.title")));
        this.playerSettingsDto = playerSettingsDto;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.questLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel("player-settings.menu.setting.quests-hide-chat")).withWidth(this.f_96543_ - 20).withPosition(20, 25).complete();
        this.questCheckbox = ECCheckbox.Builder.start(200, 25).withText(I18n.getLabel("player-settings.menu.checkbox.enabled")).withDefaultSelected(this.playerSettingsDto.hideChatDuringQuests()).withOnClick(this::onQuestCheckboxClick).complete();
        this.plotMinimapLabel = ECMultiLineField.Builder.start().withLabel(I18n.getLabel("player-settings.menu.setting.plots-show-minimap")).withWidth(this.f_96543_ - 20).withPosition(20, 45).complete();
        this.plotMinimapCheckbox = ECCheckbox.Builder.start(200, 45).withText(I18n.getLabel("player-settings.menu.checkbox.enabled")).withDefaultSelected(this.playerSettingsDto.showPlotMinimap()).withOnClick(this::onPlotMinimapCheckboxClick).complete();
        this.m_7787_((GuiEventListener)this.questCheckbox);
        this.m_7787_((GuiEventListener)this.plotMinimapCheckbox);
    }

    private void onQuestCheckboxClick(ECCheckbox<Object> c) {
        ServerBoundPlayerSettingsUpdatePacket packet = new ServerBoundPlayerSettingsUpdatePacket(c.isSelected(), null);
        Network.sendToServer(packet);
        this.flipCheckbox(c);
    }

    private void onPlotMinimapCheckboxClick(ECCheckbox<Object> c) {
        ServerBoundPlayerSettingsUpdatePacket packet = new ServerBoundPlayerSettingsUpdatePacket(null, c.isSelected());
        Network.sendToServer(packet);
        this.flipCheckbox(c);
    }

    private void flipCheckbox(ECCheckbox<Object> c) {
        if (c.isSelected()) {
            c.select();
        } else {
            c.deselect();
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PlayerSettingsMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.questLabel.render(poseStack);
        this.plotMinimapLabel.render(poseStack);
        this.questCheckbox.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.plotMinimapCheckbox.m_6305_(poseStack, mouseX, mouseY, partialTick);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

