/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.salesbarn.SalesBarnHorseInfo;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundSalesBarnBuyMenuClosePacket;
import com.equestricraft.mod.packet.ServerBoundSalesBarnHorseBuyPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SalesBarnHorseViewMenuScreen
extends Screen {
    private final SalesBarnHorseInfo info;
    private final long unlockTime;
    private ECButton buyButton = null;

    public static void showScreen(SalesBarnHorseInfo info2, long unlockTime) {
        SalesBarnHorseViewMenuScreen screen = new SalesBarnHorseViewMenuScreen(info2, unlockTime);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected SalesBarnHorseViewMenuScreen(SalesBarnHorseInfo info2, long unlockTime) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("sales-barn.menu.title")));
        this.info = info2;
        this.unlockTime = unlockTime;
    }

    protected void m_7856_() {
        super.m_7856_();
        int center = this.f_96543_ / 2;
        ECField genderLabel = ECField.Builder.start(center, 55, 20).withLabel(I18n.getLabel("sales-barn.menu.field.gender.label")).withValue(this.info.gender()).centerAligned().complete();
        ECField ageLabel = ECField.Builder.start(center, 70, 20).withLabel(I18n.getLabel("sales-barn.menu.field.age.label")).withValue(this.info.ageDisplay()).centerAligned().complete();
        ECField priceLabel = ECField.Builder.start(center, 85, 20).withLabel(I18n.getLabel("sales-barn.menu.field.price.label")).withValue(this.info.price()).centerAligned().complete();
        this.buyButton = ECButton.Builder.start(center, 100, 150, 20).withLabel(I18n.getLabel("sales-barn.menu.button.buy.label", this.info.price())).withOnClick(() -> Network.sendToServer(new ServerBoundSalesBarnHorseBuyPacket(this.info.stallId()))).centerAligned().complete();
        this.m_142416_((GuiEventListener)genderLabel);
        this.m_142416_((GuiEventListener)ageLabel);
        this.m_142416_((GuiEventListener)priceLabel);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        SalesBarnHorseViewMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        if (this.timeExpired()) {
            SalesBarnHorseViewMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("sales-barn.menu.time-expired")), (int)(this.f_96543_ / 2), (int)125, (int)GuiConstants.COLOR_RED);
        } else {
            this.buyButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
            SalesBarnHorseViewMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("sales-barn.menu.time-limit", this.secondsUntilUnlock())), (int)(this.f_96543_ / 2), (int)150, (int)GuiConstants.COLOR_WHITE);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private boolean timeExpired() {
        return DateUtils.isInPast(this.unlockTime);
    }

    private int secondsUntilUnlock() {
        return DateUtils.secondsUntil(this.unlockTime);
    }

    public boolean m_6375_(double mouseX, double mouseY, int partialTick) {
        if (!this.timeExpired() && this.buyButton.m_6375_(mouseX, mouseY, partialTick)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        ServerBoundSalesBarnBuyMenuClosePacket packet = new ServerBoundSalesBarnBuyMenuClosePacket(this.info.stallId());
        Network.sendToServer(packet);
        super.m_7379_();
    }
}

