/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.mod.Resources;
import com.equestricraft.mod.client.gui.GuiUtil;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public abstract class ScrollablePanelWidget<T extends ECWidget>
extends ECWidget {
    private static final ResourceLocation ARROW_UP = Resources.getTextures().getGui().get("arrow_up.png");
    private static final ResourceLocation ARROW_DOWN = Resources.getTextures().getGui().get("arrow_down.png");
    private int scroll = 0;
    private int totalHeight = 0;
    private final ECButton scrollUpButton;
    private final ECButton scrollDownButton;

    protected ScrollablePanelWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollUpButton = ECButton.Builder.start(this.dx(width), this.dy(0), 15, 15).withIcon(ARROW_UP, 15, 15).withOnClick(this::scrollUp).withButtonColor(Argb.ARGB_WHITE).withDefaultTransparency(0).withHoverTransparency(50).rightAligned().complete();
        this.scrollDownButton = ECButton.Builder.start(this.dx(width), this.dy(height - 15), 15, 15).withIcon(ARROW_DOWN, 15, 15).withOnClick(this::scrollDown).withButtonColor(Argb.ARGB_WHITE).withDefaultTransparency(0).withHoverTransparency(50).rightAligned().complete();
    }

    protected int getUsableWidth() {
        return this.f_93618_ - 20;
    }

    private void scrollUp() {
        this.scroll += 20;
        if (this.scroll > 0) {
            this.scroll = 0;
        }
    }

    private void scrollDown() {
        this.scroll -= 20;
    }

    protected abstract List<T> getItems();

    public int getSpacing() {
        return 5;
    }

    protected String getEmptyListLabel() {
        return null;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int currentY = 0;
        List<T> items = this.getItems();
        if (items.isEmpty()) {
            String emptyListLabel = this.getEmptyListLabel();
            if (emptyListLabel != null) {
                ECField label = ECField.Builder.start(this.dx(this.f_93618_ / 2) - 10, this.dy(this.f_93619_ / 2), this.f_93618_).withLabel(this.getEmptyListLabel()).centerAligned().complete();
                label.m_6305_(poseStack, mouseX, mouseY, partialTick);
            }
        } else {
            for (ECWidget widget : this.getItems()) {
                widget.f_93621_ = this.dy(currentY + this.scroll);
                widget.m_6305_(poseStack, mouseX, mouseY, partialTick);
                currentY += widget.m_93694_() + this.getSpacing();
            }
        }
        this.totalHeight = currentY;
        int limit = this.totalHeight - this.f_93619_;
        if (limit > 0) {
            int totalScrollHeight = this.f_93619_ - 20;
            GuiUtil.drawFilledSquare(poseStack, this.dx(this.f_93618_ - 5), this.dy((int)((float)totalScrollHeight * this.getTotalScrollPercentage())), 5, 20, Argb.ARGB_WHITE);
            if (this.scroll < 0) {
                this.scrollUpButton.f_93621_ = this.dy(0);
                this.scrollUpButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
            }
            if (Math.abs(this.scroll) <= this.totalHeight) {
                this.scrollDownButton.f_93621_ = this.dy(this.f_93619_ - 15);
                this.scrollDownButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
            }
        }
    }

    private float getTotalScrollPercentage() {
        return (float)Math.abs(this.scroll) / (float)this.totalHeight;
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.scrollUpButton.m_6375_(mouseX, mouseY, action) || this.scrollDownButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        for (ECWidget widget : this.getItems()) {
            if (!widget.m_6375_(mouseX, mouseY, action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        double newVal = (double)this.scroll + scroll * 12.0;
        if (newVal > 0.0) {
            newVal = 0.0;
        } else {
            int limit = this.totalHeight - this.f_93619_;
            if (limit < 0) {
                return false;
            }
            if (Math.abs(newVal) > (double)limit) {
                newVal = -limit;
            }
        }
        this.scroll = (int)newVal;
        return false;
    }
}

