/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.ServerRuleListWidget;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerRulesMenuScreen
extends Screen {
    private final List<String> rules;
    private final boolean hasAgreed;
    private ECMultiLineField agreementLabel = null;
    private ServerRuleListWidget serverRuleListWidget = null;

    public static void showScreen(List<String> rules, boolean hasAgreed) {
        ServerRulesMenuScreen screen = new ServerRulesMenuScreen(rules, hasAgreed);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected ServerRulesMenuScreen(List<String> rules, boolean hasAgreed) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("server-rules.menu.title")));
        this.rules = rules;
        this.hasAgreed = hasAgreed;
    }

    protected void m_7856_() {
        super.m_7856_();
        String agreementText = this.hasAgreed ? I18n.getLabel("server-rules.menu.agreement.agreed") : I18n.getLabel("server-rules.menu.agreement.not-agreed");
        this.agreementLabel = ECMultiLineField.Builder.start().withLabel(agreementText).withWidth(this.f_96543_ - 20).withPosition(this.f_96543_ / 2, 25).centerAlign().complete();
        ECButton closeButton = ECButton.Builder.start(this.f_96543_ - 10, 10, 80, 20).withLabel(I18n.getLabel("server-rules.menu.button.close.label")).withOnClick(() -> ((ServerRulesMenuScreen)this).m_7379_()).rightAligned().complete();
        this.m_142416_((GuiEventListener)closeButton);
        this.serverRuleListWidget = new ServerRuleListWidget(10, 55, this.f_96543_ - 20, this.f_96544_ - 65, this.rules);
        this.m_142416_((GuiEventListener)this.serverRuleListWidget);
    }

    public boolean m_6050_(double mouseX, double mouseY, double partialTick) {
        return this.serverRuleListWidget.m_6050_(mouseX, mouseY, partialTick) || super.m_6050_(mouseX, mouseY, partialTick);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        ServerRulesMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        this.agreementLabel.render(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

