/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui;

import com.equestricraft.common.Argb;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.mod.client.gui.GuiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ToastDisplay {
    private static final long MESSAGE_SHOW_DURATION = 5000L;
    private static List<ToastMessage> messages = new ArrayList<ToastMessage>(0);
    private static final ReentrantLock lock = new ReentrantLock();

    public static void setMessage(TextComponent textComponent) {
        lock.lock();
        try {
            messages.add(0, new ToastMessage(textComponent, System.currentTimeMillis()));
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent event) {
        int y = 35;
        lock.lock();
        try {
            for (ToastMessage message : messages) {
                if (!message.valid()) continue;
                GuiUtil.drawCenteredString(event.getMatrixStack(), (Component)message.message(), event.getWindow().m_85445_() / 2, y, Argb.ARGB_WHITE);
                y += GuiUtil.getStandardLineHeight() + 2;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private ToastDisplay() {
    }

    static {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                lock.lock();
                try {
                    messages = messages.stream().filter(ToastMessage::valid).collect(Collectors.toList());
                }
                finally {
                    lock.unlock();
                }
            }
        }, 5000L, 5000L);
    }

    private record ToastMessage(TextComponent message, long time) {
        boolean valid() {
            return DateUtils.millisSince(this.time) <= 5000L;
        }
    }
}

