/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.approval;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.approval.PendingApprovalItem;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.approval.PendingApprovalListWidget;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundPendingApprovalResponsePacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PendingApprovalMenu
extends Screen {
    private final List<PendingApprovalItem> items;
    private PendingApprovalListWidget pendingApprovalListWidget;
    private final boolean showNoPendingApprovals;
    private final TextComponent noPendingApprovalsLabel = ComponentUtil.buildColoredTextComponent(I18n.getLabel("pending-approval-menu.no-pending-approvals.label"));

    public static void showScreen(List<PendingApprovalItem> items) {
        PendingApprovalMenu screen = new PendingApprovalMenu(items);
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    private PendingApprovalMenu(List<PendingApprovalItem> items) {
        super((Component)ComponentUtil.buildColoredTextComponent(I18n.getLabel("pending-approval.menu.title")));
        this.items = items;
        this.showNoPendingApprovals = items.isEmpty();
    }

    protected void m_7856_() {
        this.pendingApprovalListWidget = new PendingApprovalListWidget(10, 35, this.f_96543_ - 20, this.f_96544_ - 45, this.items, this::onApprove, this::onDeny);
        this.m_142416_((GuiEventListener)this.pendingApprovalListWidget);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.pendingApprovalListWidget.m_6050_(mouseX, mouseY, scroll) || super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int action) {
        return this.pendingApprovalListWidget.m_6375_(mouseX, mouseY, action) || super.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        PendingApprovalMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        if (this.showNoPendingApprovals) {
            PendingApprovalMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.noPendingApprovalsLabel, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2), (int)GuiConstants.COLOR_WHITE);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void onApprove(PendingApprovalItem item) {
        ServerBoundPendingApprovalResponsePacket packet = new ServerBoundPendingApprovalResponsePacket(item.uuid(), true);
        Network.sendToServer(packet);
        this.m_7379_();
    }

    private void onDeny(PendingApprovalItem item) {
        ServerBoundPendingApprovalResponsePacket packet = new ServerBoundPendingApprovalResponsePacket(item.uuid(), false);
        Network.sendToServer(packet);
        this.m_7379_();
    }
}

