/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.approval;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.mod.approval.PendingApprovalItem;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECMultiLineField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;

public class PendingApprovalWidget
extends ECWidget {
    private final ECField ignField;
    private final ECField durationField;
    private final ECMultiLineField messageLabel;
    private final int messageHeight;
    private final ECButton approveButton;
    private final ECButton denyButton;

    protected PendingApprovalWidget(int x, int y, int width, PendingApprovalItem item, Consumer<PendingApprovalItem> onApprove, Consumer<PendingApprovalItem> onDeny) {
        super(x, y, width, 0);
        int currentY = 5;
        this.ignField = ECField.Builder.start(this.dx(5), this.dy(currentY), width - 10).withValue(item.fromPlayer().ign()).complete();
        this.durationField = ECField.Builder.start(this.dx(5), this.dy(currentY += 15), width - 10).withValue(item.durationDisplay()).complete();
        this.messageLabel = ECMultiLineField.Builder.start().withLabel(item.message()).withWidth(width).complete();
        this.messageHeight = currentY += 15;
        this.approveButton = ECButton.Builder.start(this.dx(5), this.dy(currentY += this.messageLabel.getHeight() + 5), 120, 20).withLabel(I18n.getLabel("pending-approval.menu.button.approve.label")).withOnClick(() -> onApprove.accept(item)).complete();
        this.denyButton = ECButton.Builder.start(this.dx(130), this.dy(currentY), 120, 20).withLabel(I18n.getLabel("pending-approval.menu.button.deny.label")).withOnClick(() -> onDeny.accept(item)).complete();
        this.setHeight(currentY + 25);
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        return this.approveButton.m_6375_(mouseX, mouseY, action) || this.denyButton.m_6375_(mouseX, mouseY, action);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.ignField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.durationField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.messageLabel.position(this.dx(5), this.dy(this.messageHeight)).render(poseStack);
        this.approveButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.denyButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

