/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.bank;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.transaction.BankAccountTransactionInfo;
import com.equestricraft.mod.client.ScreenStack;
import com.equestricraft.mod.client.gui.GuiConstants;
import com.equestricraft.mod.client.gui.PageScreen;
import com.equestricraft.mod.client.gui.bank.BankAccountTransactionWidget;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.economy.BankAccountTransactionPage;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBankAccountTransactionScreenRequestPacket;
import com.equestricraft.mod.util.ComponentUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class BankAccountTransactionScreen
extends PageScreen<BankAccountTransactionPage, BankAccountTransactionInfo, BankAccountTransactionSortOrder, String> {
    private final int accountId;
    private String timeHeaderLabel = "";
    private String amountHeaderLabel = "";
    private String otherPlayerHeaderLabel = "";
    private String otherAccountHeaderLabel = "";
    private String reasonHeaderLabel = "";

    public static void showScreen(int accountId, String accountName, BankAccountTransactionPage page) {
        BankAccountTransactionScreen screen = new BankAccountTransactionScreen(accountId, accountName, page);
        ScreenStack.getInstance().push(screen);
    }

    private BankAccountTransactionScreen(int accountId, String accountName, BankAccountTransactionPage page) {
        super(I18n.getLabel("bank.account-transactions.menu.title", accountName), page);
        this.accountId = accountId;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.initSearch();
        this.initTable();
        this.initSortOrderButton();
        this.initSortDirectionButton();
    }

    private void initSearch() {
        EditBox searchText = new EditBox(this.f_96547_, 5, 7, 100, 15, (Component)ComponentUtil.buildColoredTextComponent(""));
        searchText.m_94144_((String)((BankAccountTransactionPage)this.page).getFilterObject());
        ECButton searchButton = ECButton.Builder.start(110, 7, 50, 15).withLabel(I18n.getLabel("bank.account-transactions.menu.button.search.label")).withOnClick(() -> {
            String text = searchText.m_94155_();
            ServerBoundBankAccountTransactionScreenRequestPacket packet = new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, ((BankAccountTransactionPage)this.page).getPageNumber(), ((BankAccountTransactionPage)this.page).getSortDirection(), (BankAccountTransactionSortOrder)((Object)((Object)((BankAccountTransactionPage)this.page).getSortOrder())), text);
            Network.sendToServer(packet);
        }).complete();
        this.m_142416_((GuiEventListener)searchText);
        this.m_142416_((GuiEventListener)searchButton);
    }

    private void initTable() {
        this.timeHeaderLabel = I18n.getLabel("bank.account-transactions.menu.header.time.label");
        this.amountHeaderLabel = I18n.getLabel("bank.account-transactions.menu.header.amount.label");
        this.otherPlayerHeaderLabel = I18n.getLabel("bank.account-transactions.menu.header.player.label");
        this.otherAccountHeaderLabel = I18n.getLabel("bank.account-transactions.menu.header.account.label");
        this.reasonHeaderLabel = I18n.getLabel("bank.account-transactions.menu.header.reason.label");
        int x = 20;
        int y = 50;
        for (BankAccountTransactionInfo item : ((BankAccountTransactionPage)this.page).getItems()) {
            BankAccountTransactionWidget line = new BankAccountTransactionWidget(x, y, this.f_96543_ - 40, item);
            y += 15;
            this.m_142416_((GuiEventListener)line);
        }
    }

    private void initSortOrderButton() {
        ECButton.Builder sortOrderButton = ECButton.Builder.start(40, this.f_96544_ - 25, 100, 20);
        if (((BankAccountTransactionPage)this.page).getSortOrder() == BankAccountTransactionSortOrder.VALUE) {
            sortOrderButton = sortOrderButton.withLabel(I18n.getLabel("bank.account-transactions.menu.button.sort-by-time.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, ((BankAccountTransactionPage)this.page).getPageNumber(), ((BankAccountTransactionPage)this.page).getSortDirection(), BankAccountTransactionSortOrder.TIME_STAMP, (String)((BankAccountTransactionPage)this.page).getFilterObject())));
        } else if (((BankAccountTransactionPage)this.page).getSortOrder() == BankAccountTransactionSortOrder.TIME_STAMP) {
            sortOrderButton = sortOrderButton.withLabel(I18n.getLabel("bank.account-transactions.menu.button.sort-by-value.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, ((BankAccountTransactionPage)this.page).getPageNumber(), ((BankAccountTransactionPage)this.page).getSortDirection(), BankAccountTransactionSortOrder.VALUE, (String)((BankAccountTransactionPage)this.page).getFilterObject())));
        }
        this.m_142416_((GuiEventListener)sortOrderButton.complete());
    }

    private void initSortDirectionButton() {
        ECButton.Builder sortDirectionButton = ECButton.Builder.start(this.f_96543_ - 140, this.f_96544_ - 25, 100, 20);
        if (((BankAccountTransactionPage)this.page).getSortDirection() == SortDirection.ASCENDING) {
            sortDirectionButton = sortDirectionButton.withLabel(I18n.getLabel("bank.account-transactions.menu.button.order-descending.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, ((BankAccountTransactionPage)this.page).getPageNumber(), SortDirection.DESCENDING, (BankAccountTransactionSortOrder)((Object)((Object)((BankAccountTransactionPage)this.page).getSortOrder())), (String)((BankAccountTransactionPage)this.page).getFilterObject())));
        } else if (((BankAccountTransactionPage)this.page).getSortDirection() == SortDirection.DESCENDING) {
            sortDirectionButton = sortDirectionButton.withLabel(I18n.getLabel("bank.account-transactions.menu.button.order-ascending.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, ((BankAccountTransactionPage)this.page).getPageNumber(), SortDirection.ASCENDING, (BankAccountTransactionSortOrder)((Object)((Object)((BankAccountTransactionPage)this.page).getSortOrder())), (String)((BankAccountTransactionPage)this.page).getFilterObject())));
        }
        this.m_142416_((GuiEventListener)sortDirectionButton.complete());
    }

    @Override
    public void onChangePage(int newPageNumber) {
        Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(this.accountId, newPageNumber, ((BankAccountTransactionPage)this.page).getSortDirection(), (BankAccountTransactionSortOrder)((Object)((BankAccountTransactionPage)this.page).getSortOrder()), (String)((BankAccountTransactionPage)this.page).getFilterObject()));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        BankAccountTransactionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.m_96636_(), (int)(this.f_96543_ / 2), (int)10, (int)GuiConstants.COLOR_WINDOW_TITLE_PRIMARY);
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 0.9f);
        int x = 20;
        BankAccountTransactionScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.timeHeaderLabel, (int)x, (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        BankAccountTransactionScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.amountHeaderLabel, (int)(x += 80), (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        BankAccountTransactionScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.otherPlayerHeaderLabel, (int)(x += 80), (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        BankAccountTransactionScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.otherAccountHeaderLabel, (int)(x += 80), (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        BankAccountTransactionScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.reasonHeaderLabel, (int)(x += 90), (int)35, (int)GuiConstants.COLOR_WINDOW_TITLE_SECONDARY);
        poseStack.m_85849_();
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        super.m_7379_();
        ScreenStack.getInstance().back();
    }
}

