/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.client.gui.bank;

import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.common.BankAccountType;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.economy.account.BankAccountInfo;
import com.equestricraft.mod.client.gui.components.ECButton;
import com.equestricraft.mod.client.gui.components.ECField;
import com.equestricraft.mod.client.gui.components.ECWidget;
import com.equestricraft.mod.economy.BankAccountTransactionSortOrder;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ServerBoundBankAccountDepositIntoRequestPacket;
import com.equestricraft.mod.packet.ServerBoundBankAccountRenameAccountRequestPacket;
import com.equestricraft.mod.packet.ServerBoundBankAccountTransactionScreenRequestPacket;
import com.equestricraft.mod.packet.ServerBoundBankAccountWithdrawFromRequestPacket;
import com.mojang.blaze3d.vertex.PoseStack;

public class BankAccountWidget
extends ECWidget {
    private final ECField nameField;
    private final ECField typeField;
    private final ECField balanceField;
    private final ECButton viewTransactionsButton;
    private final ECButton renameButton;
    private final ECButton depositButton;
    private final ECButton withdrawButton;

    protected BankAccountWidget(int x, int y, int width, int height, BankAccountInfo bankAccountInfo) {
        super(x, y, width, height);
        this.nameField = ECField.Builder.start(this.dx(0), this.dy(0), width).withLabel(I18n.getLabel("bank.my-accounts.menu.item.field.name.label")).withValue(bankAccountInfo.accountName()).complete();
        this.typeField = ECField.Builder.start(this.dx(0), this.dy(15), width).withLabel(I18n.getLabel("bank.my-accounts.menu.item.field.type.label")).withValue(bankAccountInfo.type().getTranslatedName()).complete();
        this.balanceField = ECField.Builder.start(this.dx(0), this.dy(30), width).withLabel(I18n.getLabel("bank.my-accounts.menu.item.field.balance.label")).withValue(bankAccountInfo.balanceFormatted()).complete();
        this.viewTransactionsButton = ECButton.Builder.start(this.dx(0), this.dy(45), width, 20).withLabel(I18n.getLabel("bank.my-accounts.menu.item.button.view-transactions.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountTransactionScreenRequestPacket(bankAccountInfo.accountId(), 1, SortDirection.DESCENDING, BankAccountTransactionSortOrder.TIME_STAMP, ""))).complete();
        if (bankAccountInfo.type() != BankAccountType.MAIN) {
            this.renameButton = bankAccountInfo.type() == BankAccountType.SAVINGS ? ECButton.Builder.start(this.dx(0), this.dy(65), width, 20).withLabel(I18n.getLabel("bank.my-accounts.menu.item.button.rename.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountRenameAccountRequestPacket(bankAccountInfo.accountId()))).complete() : null;
            this.depositButton = ECButton.Builder.start(this.dx(0), this.dy(85), width, 20).withLabel(I18n.getLabel("bank.my-accounts.menu.item.button.deposit-from-main.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountDepositIntoRequestPacket(bankAccountInfo.accountId()))).complete();
            this.withdrawButton = ECButton.Builder.start(this.dx(0), this.dy(105), width, 20).withLabel(I18n.getLabel("bank.my-accounts.menu.item.button.withdraw-into-main.label")).withOnClick(() -> Network.sendToServer(new ServerBoundBankAccountWithdrawFromRequestPacket(bankAccountInfo.accountId()))).complete();
        } else {
            this.renameButton = null;
            this.depositButton = null;
            this.withdrawButton = null;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.nameField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.typeField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.balanceField.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.viewTransactionsButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.renameButton != null) {
            this.renameButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.depositButton != null) {
            this.depositButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.withdrawButton != null) {
            this.withdrawButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected boolean onClick(double mouseX, double mouseY, int action) {
        if (this.viewTransactionsButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        if (this.renameButton != null && this.renameButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        if (this.depositButton != null && this.depositButton.m_6375_(mouseX, mouseY, action)) {
            return true;
        }
        return this.withdrawButton != null && this.withdrawButton.m_6375_(mouseX, mouseY, action);
    }
}

